/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.actions;

import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.http.message.HttpMessageBuilder;
import com.consol.citrus.http.message.HttpMessageUtils;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageBuilder;
import com.consol.citrus.message.builder.ReceiveMessageBuilderSupport;
import java.util.Optional;
import javax.servlet.http.Cookie;
import org.springframework.http.HttpStatus;

public class HttpClientResponseActionBuilder
extends ReceiveMessageAction.ReceiveMessageActionBuilder<ReceiveMessageAction, HttpMessageBuilderSupport, HttpClientResponseActionBuilder> {
    private final HttpMessage httpMessage = new HttpMessage();

    public HttpClientResponseActionBuilder() {
        ((HttpMessageBuilderSupport)this.message((MessageBuilder)new HttpMessageBuilder(this.httpMessage))).headerNameIgnoreCase(true);
    }

    public HttpMessageBuilderSupport getMessageBuilderSupport() {
        if (this.messageBuilderSupport == null) {
            this.messageBuilderSupport = new HttpMessageBuilderSupport(this.httpMessage, this);
        }
        return (HttpMessageBuilderSupport)super.getMessageBuilderSupport();
    }

    public ReceiveMessageAction doBuild() {
        return new ReceiveMessageAction((ReceiveMessageAction.ReceiveMessageActionBuilder)this);
    }

    protected Optional<String> getMessagePayload() {
        if (this.httpMessage.getPayload() instanceof String) {
            return Optional.of((String)this.httpMessage.getPayload(String.class));
        }
        return super.getMessagePayload();
    }

    public static class HttpMessageBuilderSupport
    extends ReceiveMessageBuilderSupport<ReceiveMessageAction, HttpClientResponseActionBuilder, HttpMessageBuilderSupport> {
        private final HttpMessage httpMessage;

        protected HttpMessageBuilderSupport(HttpMessage httpMessage, HttpClientResponseActionBuilder delegate) {
            super((ReceiveMessageAction.ReceiveMessageActionBuilder)delegate);
            this.httpMessage = httpMessage;
        }

        public HttpMessageBuilderSupport body(String payload) {
            this.httpMessage.setPayload(payload);
            return this;
        }

        public HttpMessageBuilderSupport name(String name) {
            this.httpMessage.setName(name);
            return (HttpMessageBuilderSupport)super.name(name);
        }

        public HttpMessageBuilderSupport from(Message controlMessage) {
            HttpMessageUtils.copy(controlMessage, this.httpMessage);
            return this;
        }

        public HttpMessageBuilderSupport status(HttpStatus status) {
            this.httpMessage.status(status);
            return this;
        }

        public HttpMessageBuilderSupport statusCode(Integer statusCode) {
            this.httpMessage.statusCode(statusCode);
            return this;
        }

        public HttpMessageBuilderSupport reasonPhrase(String reasonPhrase) {
            this.httpMessage.reasonPhrase(reasonPhrase);
            return this;
        }

        public HttpMessageBuilderSupport version(String version) {
            this.httpMessage.version(version);
            return this;
        }

        public HttpMessageBuilderSupport contentType(String contentType) {
            this.httpMessage.contentType(contentType);
            return this;
        }

        public HttpMessageBuilderSupport cookie(Cookie cookie) {
            this.httpMessage.cookie(cookie);
            return this;
        }
    }
}

