/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.http.yaml;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.http.actions.HttpActionBuilder;
import com.consol.citrus.http.actions.HttpClientActionBuilder;
import com.consol.citrus.http.actions.HttpClientRequestActionBuilder;
import com.consol.citrus.http.actions.HttpClientResponseActionBuilder;
import com.consol.citrus.http.actions.HttpServerActionBuilder;
import com.consol.citrus.http.actions.HttpServerRequestActionBuilder;
import com.consol.citrus.http.actions.HttpServerResponseActionBuilder;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.yaml.actions.Message;
import com.consol.citrus.yaml.actions.Receive;
import com.consol.citrus.yaml.actions.Send;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class Http
implements TestActionBuilder<TestAction>,
ReferenceResolverAware {
    private TestActionBuilder<?> builder;
    private Receive receive;
    private Send send;
    private String description;
    private String actor;
    private ReferenceResolver referenceResolver;

    public void setDescription(String value) {
        this.description = value;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setClient(String httpClient) {
        this.builder = new HttpActionBuilder().client(httpClient);
    }

    public void setServer(String httpServer) {
        this.builder = new HttpActionBuilder().server(httpServer);
    }

    public void setSendRequest(ClientRequest request) {
        HttpClientRequestActionBuilder requestBuilder;
        HttpRequest requestMessage;
        if (request.getGET() != null) {
            requestMessage = request.getGET();
            requestBuilder = this.asClientBuilder().send().get(requestMessage.path);
        } else if (request.getPOST() != null) {
            requestMessage = request.getPOST();
            requestBuilder = this.asClientBuilder().send().post(requestMessage.path);
        } else if (request.getPUT() != null) {
            requestMessage = request.getPUT();
            requestBuilder = this.asClientBuilder().send().put(requestMessage.path);
        } else if (request.getDELETE() != null) {
            requestMessage = request.getDELETE();
            requestBuilder = this.asClientBuilder().send().delete(requestMessage.path);
        } else if (request.getHEAD() != null) {
            requestMessage = request.getHEAD();
            requestBuilder = this.asClientBuilder().send().head(requestMessage.path);
        } else if (request.getOPTIONS() != null) {
            requestMessage = request.getOPTIONS();
            requestBuilder = this.asClientBuilder().send().options(requestMessage.path);
        } else if (request.getPATCH() != null) {
            requestMessage = request.getPATCH();
            requestBuilder = this.asClientBuilder().send().patch(requestMessage.path);
        } else if (request.getTRACE() != null) {
            requestMessage = request.getTRACE();
            requestBuilder = this.asClientBuilder().send().trace(requestMessage.path);
        } else {
            throw new CitrusRuntimeException("Failed to construct proper Http client request action - missing proper Http method (GET, POST, PUT, DELETE, OPTIONS, HEAD, PATCH, TRACE)");
        }
        requestBuilder.name("http:send-request");
        requestBuilder.description(this.description);
        this.send = new Send(requestBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (request.fork != null) {
            this.send.setFork(request.fork);
        }
        this.send.setMessage((Message)requestMessage);
        if (request.extract != null) {
            this.send.setExtract(request.extract);
        }
        if (request.uri != null) {
            ((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).header("citrus_endpoint_uri", request.uri);
        }
        if (requestMessage.contentType != null) {
            ((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).contentType(requestMessage.contentType);
        }
        if (requestMessage.accept != null) {
            ((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).accept(requestMessage.accept);
        }
        if (requestMessage.version != null) {
            ((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).version(requestMessage.version);
        }
        for (HttpRequest.QueryParameter param : requestMessage.getParameters()) {
            if (param.value != null) {
                requestBuilder.queryParam(param.name, param.value);
                continue;
            }
            requestBuilder.queryParam(param.name);
        }
        this.builder = requestBuilder;
    }

    public void setReceiveResponse(ClientResponse response) {
        HttpClientResponseActionBuilder responseBuilder = (HttpClientResponseActionBuilder)this.asClientBuilder().receive().response().name("http:receive-response");
        responseBuilder.description(this.description);
        this.receive = new Receive(responseBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        if (response.getResponse() != null) {
            ((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).header("citrus_http_status_code", response.getResponse().status);
            if (response.getResponse().reasonPhrase != null) {
                ((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).reasonPhrase(response.getResponse().reasonPhrase);
            }
            if (response.getResponse().contentType != null) {
                ((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).contentType(response.getResponse().contentType);
            }
            if (response.getResponse().version != null) {
                ((HttpClientResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).version(response.getResponse().version);
            }
            this.receive.setMessage((Message)response.getResponse());
            if (response.timeout != null) {
                this.receive.setTimeout(response.timeout);
            }
            this.receive.setSelect(response.select);
            this.receive.setValidator(response.validator);
            this.receive.setValidators(response.validators);
            this.receive.setHeaderValidator(response.headerValidator);
            this.receive.setHeaderValidators(response.headerValidators);
            if (response.selector != null) {
                this.receive.setSelector(response.selector);
            }
            this.receive.setSelect(response.select);
            response.getValidate().forEach(this.receive.getValidate()::add);
            if (response.extract != null) {
                this.receive.setExtract(response.extract);
            }
        }
        this.builder = responseBuilder;
    }

    public void setReceiveRequest(ServerRequest request) {
        HttpServerRequestActionBuilder requestBuilder;
        HttpRequest requestMessage;
        if (request.getGET() != null) {
            requestMessage = request.getGET();
            requestBuilder = this.asServerBuilder().receive().get(requestMessage.path);
        } else if (request.getPOST() != null) {
            requestMessage = request.getPOST();
            requestBuilder = this.asServerBuilder().receive().post(requestMessage.path);
        } else if (request.getPUT() != null) {
            requestMessage = request.getPUT();
            requestBuilder = this.asServerBuilder().receive().put(requestMessage.path);
        } else if (request.getDELETE() != null) {
            requestMessage = request.getDELETE();
            requestBuilder = this.asServerBuilder().receive().delete(requestMessage.path);
        } else if (request.getHEAD() != null) {
            requestMessage = request.getHEAD();
            requestBuilder = this.asServerBuilder().receive().head(requestMessage.path);
        } else if (request.getOPTIONS() != null) {
            requestMessage = request.getOPTIONS();
            requestBuilder = this.asServerBuilder().receive().options(requestMessage.path);
        } else if (request.getPATCH() != null) {
            requestMessage = request.getPATCH();
            requestBuilder = this.asServerBuilder().receive().patch(requestMessage.path);
        } else if (request.getTRACE() != null) {
            requestMessage = request.getTRACE();
            requestBuilder = this.asServerBuilder().receive().trace(requestMessage.path);
        } else {
            throw new CitrusRuntimeException("Failed to construct proper Http client request action - missing proper Http method (GET, POST, PUT, DELETE, OPTIONS, HEAD, PATCH, TRACE)");
        }
        requestBuilder.name("http:receive-request");
        requestBuilder.description(this.description);
        if (requestMessage.contentType != null) {
            ((HttpServerRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).contentType(requestMessage.contentType);
        }
        if (requestMessage.accept != null) {
            ((HttpServerRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).accept(requestMessage.accept);
        }
        if (requestMessage.version != null) {
            ((HttpServerRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).version(requestMessage.version);
        }
        this.receive = new Receive(requestBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        this.receive.setMessage((Message)requestMessage);
        if (request.selector != null) {
            this.receive.setSelector(request.selector);
        }
        this.receive.setSelect(request.select);
        this.receive.setValidator(request.validator);
        this.receive.setValidators(request.validators);
        this.receive.setHeaderValidator(request.headerValidator);
        this.receive.setHeaderValidators(request.headerValidators);
        if (request.timeout != null) {
            this.receive.setTimeout(request.timeout);
        }
        request.getValidates().forEach(this.receive.getValidate()::add);
        if (request.extract != null) {
            this.receive.setExtract(request.extract);
        }
        for (HttpRequest.QueryParameter param : requestMessage.getParameters()) {
            if (param.value != null) {
                requestBuilder.queryParam(param.name, param.value);
                continue;
            }
            requestBuilder.queryParam(param.name);
        }
        this.builder = requestBuilder;
    }

    public void setSendResponse(ServerResponse response) {
        HttpServerResponseActionBuilder responseBuilder = (HttpServerResponseActionBuilder)this.asServerBuilder().send().response().name("http:send-response");
        responseBuilder.description(this.description);
        this.send = new Send(responseBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (response.getResponse() != null) {
            this.send.setMessage((Message)response.getResponse());
            if (response.extract != null) {
                this.send.setExtract(response.extract);
            }
            ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).header("citrus_http_status_code", response.getResponse().status);
            if (response.getResponse().reasonPhrase != null) {
                ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).reasonPhrase(response.getResponse().reasonPhrase);
            }
            if (response.getResponse().contentType != null) {
                ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).contentType(response.getResponse().contentType);
            }
            if (response.getResponse().version != null) {
                ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).version(response.getResponse().version);
            }
        }
        this.builder = responseBuilder;
    }

    public TestAction build() {
        if (this.builder == null) {
            throw new CitrusRuntimeException("Missing client or server Http action - please provide proper action details");
        }
        if (this.send != null) {
            this.send.setReferenceResolver(this.referenceResolver);
            this.send.setActor(this.actor);
            this.send.build();
        }
        if (this.receive != null) {
            this.receive.setReferenceResolver(this.referenceResolver);
            this.receive.setActor(this.actor);
            this.receive.build();
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    private HttpClientActionBuilder asClientBuilder() {
        if (this.builder instanceof HttpClientActionBuilder) {
            return (HttpClientActionBuilder)this.builder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to http client action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    private HttpServerActionBuilder asServerBuilder() {
        if (this.builder instanceof HttpServerActionBuilder) {
            return (HttpServerActionBuilder)this.builder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to http client action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    public static class ClientRequest {
        protected String uri;
        protected Boolean fork;
        protected HttpRequest get;
        protected HttpRequest post;
        protected HttpRequest put;
        protected HttpRequest delete;
        protected HttpRequest head;
        protected HttpRequest options;
        protected HttpRequest patch;
        protected HttpRequest trace;
        protected Message.Extract extract;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public Boolean getFork() {
            return this.fork;
        }

        public void setFork(Boolean fork) {
            this.fork = fork;
        }

        public HttpRequest getGET() {
            return this.get;
        }

        public void setGET(HttpRequest get) {
            this.get = get;
        }

        public HttpRequest getPOST() {
            return this.post;
        }

        public void setPOST(HttpRequest post) {
            this.post = post;
        }

        public HttpRequest getPUT() {
            return this.put;
        }

        public void setPUT(HttpRequest put) {
            this.put = put;
        }

        public HttpRequest getDELETE() {
            return this.delete;
        }

        public void setDELETE(HttpRequest delete) {
            this.delete = delete;
        }

        public HttpRequest getHEAD() {
            return this.head;
        }

        public void setHEAD(HttpRequest head) {
            this.head = head;
        }

        public HttpRequest getOPTIONS() {
            return this.options;
        }

        public void setOPTIONS(HttpRequest options) {
            this.options = options;
        }

        public HttpRequest getPATCH() {
            return this.patch;
        }

        public void setPATCH(HttpRequest patch) {
            this.patch = patch;
        }

        public HttpRequest getTRACE() {
            return this.trace;
        }

        public void setTRACE(HttpRequest trace) {
            this.trace = trace;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    public static class HttpRequest
    extends Message {
        protected String path;
        protected String contentType;
        protected String accept;
        protected String version;
        protected List<QueryParameter> parameters;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getAccept() {
            return this.accept;
        }

        public void setAccept(String accept) {
            this.accept = accept;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public List<QueryParameter> getParameters() {
            if (this.parameters == null) {
                this.parameters = new ArrayList<QueryParameter>();
            }
            return this.parameters;
        }

        public void setParameters(List<QueryParameter> parameters) {
            this.parameters = parameters;
        }

        public static class QueryParameter {
            protected String name;
            protected String value;

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public String getValue() {
                return this.value;
            }

            public void setValue(String value) {
                this.value = value;
            }
        }
    }

    public static class ClientResponse {
        protected Integer timeout;
        protected String select;
        protected String validator;
        protected String validators;
        protected String headerValidator;
        protected String headerValidators;
        protected Receive.Selector selector;
        protected HttpResponse response;
        protected List<Receive.Validate> validate;
        protected Message.Extract extract;

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public Receive.Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Receive.Selector selector) {
            this.selector = selector;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        public List<Receive.Validate> getValidate() {
            if (this.validate == null) {
                this.validate = new ArrayList<Receive.Validate>();
            }
            return this.validate;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    public static class HttpResponse
    extends Message {
        protected String status = "200";
        protected String reasonPhrase;
        protected String version;
        protected String contentType;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }

        public void setReasonPhrase(String reasonPhrase) {
            this.reasonPhrase = reasonPhrase;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getContentType() {
            return this.contentType;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }
    }

    public static class ServerRequest {
        protected Integer timeout;
        protected String select;
        protected String validator;
        protected String validators;
        protected String headerValidator;
        protected String headerValidators;
        protected HttpRequest get;
        protected HttpRequest post;
        protected HttpRequest put;
        protected HttpRequest delete;
        protected HttpRequest head;
        protected HttpRequest options;
        protected HttpRequest patch;
        protected HttpRequest trace;
        protected Receive.Selector selector;
        protected List<Receive.Validate> validates;
        protected Message.Extract extract;

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public HttpRequest getGET() {
            return this.get;
        }

        public void setGET(HttpRequest get) {
            this.get = get;
        }

        public HttpRequest getPOST() {
            return this.post;
        }

        public void setPOST(HttpRequest post) {
            this.post = post;
        }

        public HttpRequest getPUT() {
            return this.put;
        }

        public void setPUT(HttpRequest put) {
            this.put = put;
        }

        public HttpRequest getDELETE() {
            return this.delete;
        }

        public void setDELETE(HttpRequest delete) {
            this.delete = delete;
        }

        public HttpRequest getHEAD() {
            return this.head;
        }

        public void setHEAD(HttpRequest head) {
            this.head = head;
        }

        public HttpRequest getOPTIONS() {
            return this.options;
        }

        public void setOPTIONS(HttpRequest options) {
            this.options = options;
        }

        public HttpRequest getPATCH() {
            return this.patch;
        }

        public void setPATCH(HttpRequest patch) {
            this.patch = patch;
        }

        public HttpRequest getTRACE() {
            return this.trace;
        }

        public void setTRACE(HttpRequest trace) {
            this.trace = trace;
        }

        public Receive.Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Receive.Selector selector) {
            this.selector = selector;
        }

        public List<Receive.Validate> getValidates() {
            if (this.validates == null) {
                this.validates = new ArrayList<Receive.Validate>();
            }
            return this.validates;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    public static class ServerResponse {
        protected HttpResponse response;
        protected Message.Extract extract;

        public HttpResponse getResponse() {
            return this.response;
        }

        public void setResponse(HttpResponse response) {
            this.response = response;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }
}

