/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.annotations;

import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.dsl.design.TestDesigner;
import com.consol.citrus.dsl.runner.TestRunner;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public abstract class CitrusDslAnnotations {
    private static Logger log = LoggerFactory.getLogger(CitrusDslAnnotations.class);

    private CitrusDslAnnotations() {
    }

    public static void injectTestDesigner(Object target, TestDesigner designer) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            Class<?> type = field.getType();
            if (!TestDesigner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            log.debug(String.format("Injecting test designer instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)designer);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && TestDesigner.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
    }

    public static void injectTestRunner(Object target, TestRunner runner) {
        ReflectionUtils.doWithFields(target.getClass(), field -> {
            Class<?> type = field.getType();
            if (!TestRunner.class.isAssignableFrom(type)) {
                throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + type);
            }
            log.debug(String.format("Injecting test runner instance on test class field '%s'", field.getName()));
            ReflectionUtils.setField((Field)field, (Object)target, (Object)runner);
        }, field -> {
            if (field.isAnnotationPresent(CitrusResource.class) && TestRunner.class.isAssignableFrom(field.getType())) {
                if (!field.isAccessible()) {
                    ReflectionUtils.makeAccessible((Field)field);
                }
                return true;
            }
            return false;
        });
    }
}

