/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.TestAction;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.dsl.actions.DelegatingTestAction;
import com.consol.citrus.dsl.builder.AbstractTestActionBuilder;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.HeaderValidator;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.MessageContentBuilder;
import com.consol.citrus.validation.builder.PayloadTemplateMessageBuilder;
import com.consol.citrus.validation.builder.StaticMessageContentBuilder;
import com.consol.citrus.validation.callback.ValidationCallback;
import com.consol.citrus.validation.context.HeaderValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.json.JsonMessageValidationContext;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.json.JsonPathVariableExtractor;
import com.consol.citrus.validation.script.ScriptValidationContext;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.validation.xml.XpathMessageValidationContext;
import com.consol.citrus.validation.xml.XpathPayloadVariableExtractor;
import com.consol.citrus.variable.MessageHeaderVariableExtractor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.transform.Result;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.XmlMappingException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.xml.transform.StringResult;

public class ReceiveMessageBuilder<A extends ReceiveMessageAction, T extends ReceiveMessageBuilder>
extends AbstractTestActionBuilder<DelegatingTestAction<TestAction>> {
    private final T self;
    private String messageType;
    private HeaderValidationContext headerValidationContext = new HeaderValidationContext();
    private XmlMessageValidationContext xmlMessageValidationContext = new XmlMessageValidationContext();
    private JsonMessageValidationContext jsonMessageValidationContext = new JsonMessageValidationContext();
    private JsonPathMessageValidationContext jsonPathValidationContext;
    private ScriptValidationContext scriptValidationContext;
    private MessageHeaderVariableExtractor headerExtractor;
    private XpathPayloadVariableExtractor xpathExtractor;
    private JsonPathVariableExtractor jsonPathExtractor;
    private ApplicationContext applicationContext;

    public ReceiveMessageBuilder(A action) {
        this(new DelegatingTestAction<TestAction>((TestAction)action));
    }

    public ReceiveMessageBuilder() {
        this(new ReceiveMessageAction());
    }

    public ReceiveMessageBuilder(DelegatingTestAction<TestAction> action) {
        super(action);
        this.self = this;
    }

    public ReceiveMessageBuilder endpoint(Endpoint messageEndpoint) {
        this.getAction().setEndpoint(messageEndpoint);
        return this;
    }

    public ReceiveMessageBuilder endpoint(String messageEndpointUri) {
        this.getAction().setEndpointUri(messageEndpointUri);
        return this;
    }

    public T timeout(long receiveTimeout) {
        this.getAction().setReceiveTimeout(receiveTimeout);
        return this.self;
    }

    public T message(Message controlMessage) {
        StaticMessageContentBuilder staticMessageContentBuilder = StaticMessageContentBuilder.withMessage((Message)controlMessage);
        staticMessageContentBuilder.setMessageHeaders(this.getMessageContentBuilder().getMessageHeaders());
        this.getAction().setMessageBuilder((MessageContentBuilder)staticMessageContentBuilder);
        return this.self;
    }

    protected void setPayload(String payload) {
        AbstractMessageContentBuilder messageContentBuilder = this.getMessageContentBuilder();
        if (messageContentBuilder instanceof PayloadTemplateMessageBuilder) {
            ((PayloadTemplateMessageBuilder)messageContentBuilder).setPayloadData(payload);
        } else if (messageContentBuilder instanceof StaticMessageContentBuilder) {
            ((StaticMessageContentBuilder)messageContentBuilder).getMessage().setPayload((Object)payload);
        } else {
            throw new CitrusRuntimeException("Unable to set payload on message builder type: " + messageContentBuilder.getClass());
        }
    }

    public T name(String name) {
        this.getMessageContentBuilder().setMessageName(name);
        return this.self;
    }

    public T payload(String payload) {
        this.setPayload(payload);
        return this.self;
    }

    public T payload(Resource payloadResource) {
        return this.payload(payloadResource, FileUtils.getDefaultCharset());
    }

    public T payload(Resource payloadResource, Charset charset) {
        try {
            this.setPayload(FileUtils.readToString((Resource)payloadResource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read payload resource", (Throwable)e);
        }
        return this.self;
    }

    public T payload(Object payload, Marshaller marshaller) {
        StringResult result = new StringResult();
        try {
            marshaller.marshal(payload, (Result)result);
        }
        catch (XmlMappingException e) {
            throw new CitrusRuntimeException("Failed to marshal object graph for message payload", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to marshal object graph for message payload", (Throwable)e);
        }
        this.setPayload(result.toString());
        return this.self;
    }

    public T payload(Object payload, ObjectMapper objectMapper) {
        try {
            this.setPayload(objectMapper.writer().writeValueAsString(payload));
        }
        catch (JsonProcessingException e) {
            throw new CitrusRuntimeException("Failed to map object graph for message payload", (Throwable)e);
        }
        return this.self;
    }

    public T payloadModel(Object payload) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        if (!CollectionUtils.isEmpty((Map)this.applicationContext.getBeansOfType(Marshaller.class))) {
            return this.payload(payload, (Marshaller)this.applicationContext.getBean(Marshaller.class));
        }
        if (!CollectionUtils.isEmpty((Map)this.applicationContext.getBeansOfType(ObjectMapper.class))) {
            return this.payload(payload, (ObjectMapper)this.applicationContext.getBean(ObjectMapper.class));
        }
        throw new CitrusRuntimeException("Unable to find default object mapper or marshaller in application context");
    }

    public T payload(Object payload, String mapperName) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        if (this.applicationContext.containsBean(mapperName)) {
            Object mapper = this.applicationContext.getBean(mapperName);
            if (Marshaller.class.isAssignableFrom(mapper.getClass())) {
                return this.payload(payload, (Marshaller)mapper);
            }
            if (ObjectMapper.class.isAssignableFrom(mapper.getClass())) {
                return this.payload(payload, (ObjectMapper)mapper);
            }
            throw new CitrusRuntimeException(String.format("Invalid bean type for mapper '%s' expected ObjectMapper or Marshaller but was '%s'", mapperName, mapper.getClass()));
        }
        throw new CitrusRuntimeException("Unable to find default object mapper or marshaller in application context");
    }

    public T header(String name, Object value) {
        this.getMessageContentBuilder().getMessageHeaders().put(name, value);
        return this.self;
    }

    public T headers(Map<String, Object> headers) {
        this.getMessageContentBuilder().getMessageHeaders().putAll(headers);
        return this.self;
    }

    public T header(String data) {
        this.getMessageContentBuilder().getHeaderData().add(data);
        return this.self;
    }

    public T headerFragment(Object model) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        if (!CollectionUtils.isEmpty((Map)this.applicationContext.getBeansOfType(Marshaller.class))) {
            return this.headerFragment(model, (Marshaller)this.applicationContext.getBean(Marshaller.class));
        }
        if (!CollectionUtils.isEmpty((Map)this.applicationContext.getBeansOfType(ObjectMapper.class))) {
            return this.headerFragment(model, (ObjectMapper)this.applicationContext.getBean(ObjectMapper.class));
        }
        throw new CitrusRuntimeException("Unable to find default object mapper or marshaller in application context");
    }

    public T headerFragment(Object model, String mapperName) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        if (this.applicationContext.containsBean(mapperName)) {
            Object mapper = this.applicationContext.getBean(mapperName);
            if (Marshaller.class.isAssignableFrom(mapper.getClass())) {
                return this.headerFragment(model, (Marshaller)mapper);
            }
            if (ObjectMapper.class.isAssignableFrom(mapper.getClass())) {
                return this.headerFragment(model, (ObjectMapper)mapper);
            }
            throw new CitrusRuntimeException(String.format("Invalid bean type for mapper '%s' expected ObjectMapper or Marshaller but was '%s'", mapperName, mapper.getClass()));
        }
        throw new CitrusRuntimeException("Unable to find default object mapper or marshaller in application context");
    }

    public T headerFragment(Object model, Marshaller marshaller) {
        StringResult result = new StringResult();
        try {
            marshaller.marshal(model, (Result)result);
        }
        catch (XmlMappingException e) {
            throw new CitrusRuntimeException("Failed to marshal object graph for message header data", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to marshal object graph for message header data", (Throwable)e);
        }
        return this.header(result.toString());
    }

    public T headerFragment(Object model, ObjectMapper objectMapper) {
        try {
            return this.header(objectMapper.writer().writeValueAsString(model));
        }
        catch (JsonProcessingException e) {
            throw new CitrusRuntimeException("Failed to map object graph for message header data", (Throwable)e);
        }
    }

    public T header(Resource resource) {
        return this.header(resource, FileUtils.getDefaultCharset());
    }

    public T header(Resource resource, Charset charset) {
        try {
            this.getMessageContentBuilder().getHeaderData().add(FileUtils.readToString((Resource)resource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read header resource", (Throwable)e);
        }
        return this.self;
    }

    public T headerNameIgnoreCase(boolean value) {
        this.headerValidationContext.setHeaderNameIgnoreCase(value);
        return this.self;
    }

    public T validateScript(String validationScript) {
        this.getScriptValidationContext().setValidationScript(validationScript);
        return this.self;
    }

    public T validateScript(Resource scriptResource) {
        return this.validateScript(scriptResource, FileUtils.getDefaultCharset());
    }

    public T validateScript(Resource scriptResource, Charset charset) {
        try {
            this.validateScript(FileUtils.readToString((Resource)scriptResource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read script resource file", (Throwable)e);
        }
        return this.self;
    }

    public T validateScriptResource(String fileResourcePath) {
        this.getScriptValidationContext().setValidationScriptResourcePath(fileResourcePath);
        return this.self;
    }

    public T validateScriptType(String type) {
        this.getScriptValidationContext().setScriptType(type);
        return this.self;
    }

    public T messageType(MessageType messageType) {
        this.messageType(messageType.name());
        return this.self;
    }

    public T messageType(String messageType) {
        this.messageType = messageType;
        this.getAction().setMessageType(messageType);
        if (this.getAction().getValidationContexts().isEmpty()) {
            this.getAction().getValidationContexts().add(this.headerValidationContext);
            this.getAction().getValidationContexts().add(this.xmlMessageValidationContext);
            this.getAction().getValidationContexts().add(this.jsonMessageValidationContext);
        }
        return this.self;
    }

    public T schemaValidation(boolean enabled) {
        this.xmlMessageValidationContext.setSchemaValidation(enabled);
        this.jsonMessageValidationContext.setSchemaValidation(enabled);
        return this.self;
    }

    public T validateNamespace(String prefix, String namespaceUri) {
        this.xmlMessageValidationContext.getControlNamespaces().put(prefix, namespaceUri);
        return this.self;
    }

    public T validate(String path, Object controlValue) {
        if (JsonPathMessageValidationContext.isJsonPathExpression((String)path)) {
            this.getJsonPathValidationContext().getJsonPathExpressions().put(path, controlValue);
        } else {
            this.getXPathValidationContext().getXpathExpressions().put(path, controlValue);
        }
        return this.self;
    }

    public T ignore(String path) {
        if (this.messageType.equalsIgnoreCase(MessageType.XML.name()) || this.messageType.equalsIgnoreCase(MessageType.XHTML.name())) {
            this.xmlMessageValidationContext.getIgnoreExpressions().add(path);
        } else if (this.messageType.equalsIgnoreCase(MessageType.JSON.name())) {
            this.jsonMessageValidationContext.getIgnoreExpressions().add(path);
        }
        return this.self;
    }

    public T xpath(String xPathExpression, Object controlValue) {
        this.validate(xPathExpression, controlValue);
        return this.self;
    }

    public T jsonPath(String jsonPathExpression, Object controlValue) {
        this.validate(jsonPathExpression, controlValue);
        return this.self;
    }

    public T xsd(String schemaName) {
        this.xmlMessageValidationContext.setSchema(schemaName);
        return this.self;
    }

    public T jsonSchema(String schemaName) {
        this.jsonMessageValidationContext.setSchema(schemaName);
        return this.self;
    }

    public T xsdSchemaRepository(String schemaRepository) {
        this.xmlMessageValidationContext.setSchemaRepository(schemaRepository);
        return this.self;
    }

    public T jsonSchemaRepository(String schemaRepository) {
        this.jsonMessageValidationContext.setSchemaRepository(schemaRepository);
        return this.self;
    }

    public T namespace(String prefix, String namespaceUri) {
        this.getXpathVariableExtractor().getNamespaces().put(prefix, namespaceUri);
        this.xmlMessageValidationContext.getNamespaces().put(prefix, namespaceUri);
        return this.self;
    }

    public T namespaces(Map<String, String> namespaceMappings) {
        this.getXpathVariableExtractor().getNamespaces().putAll(namespaceMappings);
        this.xmlMessageValidationContext.getNamespaces().putAll(namespaceMappings);
        return this.self;
    }

    public T selector(String messageSelector) {
        this.getAction().setMessageSelector(messageSelector);
        return this.self;
    }

    public T selector(Map<String, Object> messageSelector) {
        this.getAction().setMessageSelectorMap(messageSelector);
        return this.self;
    }

    public T validator(MessageValidator<? extends ValidationContext> ... validators) {
        Stream.of(validators).forEach(arg_0 -> ((ReceiveMessageAction)this.getAction()).addValidator(arg_0));
        return this.self;
    }

    public T validator(String ... validatorNames) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        for (String validatorName : validatorNames) {
            this.getAction().addValidator((MessageValidator)this.applicationContext.getBean(validatorName, MessageValidator.class));
        }
        return this.self;
    }

    public T headerValidator(HeaderValidator ... validators) {
        Stream.of(validators).forEach(arg_0 -> ((HeaderValidationContext)this.headerValidationContext).addHeaderValidator(arg_0));
        return this.self;
    }

    public T headerValidator(String ... validatorNames) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        for (String validatorName : validatorNames) {
            this.headerValidationContext.addHeaderValidator((HeaderValidator)this.applicationContext.getBean(validatorName, HeaderValidator.class));
        }
        return this.self;
    }

    public T dictionary(DataDictionary dictionary) {
        this.getAction().setDataDictionary(dictionary);
        return this.self;
    }

    public T dictionary(String dictionaryName) {
        Assert.notNull((Object)this.applicationContext, (String)"Citrus application context is not initialized!");
        DataDictionary dictionary = (DataDictionary)this.applicationContext.getBean(dictionaryName, DataDictionary.class);
        this.getAction().setDataDictionary(dictionary);
        return this.self;
    }

    public T extractFromHeader(String headerName, String variable) {
        if (this.headerExtractor == null) {
            this.headerExtractor = new MessageHeaderVariableExtractor();
            this.getAction().getVariableExtractors().add(this.headerExtractor);
        }
        this.headerExtractor.getHeaderMappings().put(headerName, variable);
        return this.self;
    }

    public T extractFromPayload(String path, String variable) {
        if (JsonPathMessageValidationContext.isJsonPathExpression((String)path)) {
            this.getJsonPathVariableExtractor().getJsonPathExpressions().put(path, variable);
        } else {
            this.getXpathVariableExtractor().getXpathExpressions().put(path, variable);
        }
        return this.self;
    }

    public T validationCallback(ValidationCallback callback) {
        if (callback instanceof ApplicationContextAware) {
            ((ApplicationContextAware)callback).setApplicationContext(this.applicationContext);
        }
        this.getAction().setValidationCallback(callback);
        return this.self;
    }

    public T withApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        return this.self;
    }

    protected AbstractMessageContentBuilder getMessageContentBuilder() {
        if (this.getAction().getMessageBuilder() != null && this.getAction().getMessageBuilder() instanceof AbstractMessageContentBuilder) {
            return (AbstractMessageContentBuilder)this.getAction().getMessageBuilder();
        }
        PayloadTemplateMessageBuilder messageBuilder = new PayloadTemplateMessageBuilder();
        this.getAction().setMessageBuilder((MessageContentBuilder)messageBuilder);
        return messageBuilder;
    }

    private XpathPayloadVariableExtractor getXpathVariableExtractor() {
        if (this.xpathExtractor == null) {
            this.xpathExtractor = new XpathPayloadVariableExtractor();
            this.getAction().getVariableExtractors().add(this.xpathExtractor);
        }
        return this.xpathExtractor;
    }

    private JsonPathVariableExtractor getJsonPathVariableExtractor() {
        if (this.jsonPathExtractor == null) {
            this.jsonPathExtractor = new JsonPathVariableExtractor();
            this.getAction().getVariableExtractors().add(this.jsonPathExtractor);
        }
        return this.jsonPathExtractor;
    }

    private XpathMessageValidationContext getXPathValidationContext() {
        if (this.xmlMessageValidationContext instanceof XpathMessageValidationContext) {
            return (XpathMessageValidationContext)this.xmlMessageValidationContext;
        }
        XpathMessageValidationContext xPathContext = new XpathMessageValidationContext();
        xPathContext.setNamespaces(this.xmlMessageValidationContext.getNamespaces());
        xPathContext.setControlNamespaces(this.xmlMessageValidationContext.getControlNamespaces());
        xPathContext.setIgnoreExpressions(this.xmlMessageValidationContext.getIgnoreExpressions());
        xPathContext.setSchema(this.xmlMessageValidationContext.getSchema());
        xPathContext.setSchemaRepository(this.xmlMessageValidationContext.getSchemaRepository());
        xPathContext.setSchemaValidation(this.xmlMessageValidationContext.isSchemaValidationEnabled());
        xPathContext.setDTDResource(this.xmlMessageValidationContext.getDTDResource());
        this.getAction().getValidationContexts().remove(this.xmlMessageValidationContext);
        this.getAction().getValidationContexts().add(xPathContext);
        this.xmlMessageValidationContext = xPathContext;
        return xPathContext;
    }

    private ScriptValidationContext getScriptValidationContext() {
        if (this.scriptValidationContext == null) {
            this.scriptValidationContext = new ScriptValidationContext(this.messageType.toString());
            this.getAction().getValidationContexts().add(this.scriptValidationContext);
        }
        return this.scriptValidationContext;
    }

    private JsonPathMessageValidationContext getJsonPathValidationContext() {
        if (this.jsonPathValidationContext == null) {
            this.jsonPathValidationContext = new JsonPathMessageValidationContext();
            this.getAction().getValidationContexts().add(this.jsonPathValidationContext);
        }
        return this.jsonPathValidationContext;
    }

    protected ReceiveMessageAction getAction() {
        return (ReceiveMessageAction)((DelegatingTestAction)this.action).getDelegate();
    }

    protected void setMessageType(MessageType messageType) {
        this.messageType = messageType.name();
    }

    protected void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    protected void setXpathExtractor(XpathPayloadVariableExtractor xpathExtractor) {
        this.xpathExtractor = xpathExtractor;
    }

    protected void setJsonPathExtractor(JsonPathVariableExtractor jsonPathExtractor) {
        this.jsonPathExtractor = jsonPathExtractor;
    }

    protected void setHeaderExtractor(MessageHeaderVariableExtractor headerExtractor) {
        this.headerExtractor = headerExtractor;
    }

    protected void setScriptValidationContext(ScriptValidationContext scriptValidationContext) {
        this.scriptValidationContext = scriptValidationContext;
    }

    protected void setJsonPathValidationContext(JsonPathMessageValidationContext jsonPathValidationContext) {
        this.jsonPathValidationContext = jsonPathValidationContext;
    }

    protected void setXmlMessageValidationContext(XmlMessageValidationContext validationContext) {
        this.xmlMessageValidationContext = validationContext;
    }

    protected void setJsonMessageValidationContext(JsonMessageValidationContext validationContext) {
        this.jsonMessageValidationContext = validationContext;
    }

    protected void setHeaderValidationContext(HeaderValidationContext validationContext) {
        this.headerValidationContext = validationContext;
    }
}

