/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.testng;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.design.DefaultTestDesigner;
import com.consol.citrus.dsl.design.TestDesigner;
import com.consol.citrus.dsl.runner.DefaultTestRunner;
import com.consol.citrus.dsl.runner.TestRunner;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.testng.AbstractTestNGCitrusTest;
import java.lang.reflect.Method;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.testng.IHookCallBack;
import org.testng.ITestResult;

public class TestNGCitrusTest
extends AbstractTestNGCitrusTest {
    private static final String DESIGNER_ATTRIBUTE = "designer";
    private static final String RUNNER_ATTRIBUTE = "runner";

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method != null && method.getAnnotation(CitrusTest.class) != null) {
            try {
                this.run(testResult, method, null, testResult.getMethod().getCurrentInvocationCount());
            }
            catch (RuntimeException e) {
                testResult.setThrowable((Throwable)e);
                testResult.setStatus(2);
            }
            catch (Exception e) {
                testResult.setThrowable((Throwable)e);
                testResult.setStatus(2);
            }
            super.run((IHookCallBack)new AbstractTestNGCitrusTest.FakeExecutionCallBack(callBack.getParameters()), testResult);
            if (testResult.getThrowable() != null) {
                if (testResult.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)testResult.getThrowable();
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else {
            super.run(callBack, testResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(ITestResult testResult, Method method, TestLoader testLoader, int invocationCount) {
        if (method != null && method.getAnnotation(CitrusXmlTest.class) != null) {
            super.run(testResult, method, testLoader, invocationCount);
        } else {
            try {
                Object testBuilder;
                if (this.citrus == null) {
                    this.citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)this.applicationContext));
                }
                TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
                if (this.isDesignerMethod(method)) {
                    testBuilder = this.createTestDesigner(method, ctx);
                    testBuilder.groups(testResult.getMethod().getGroups());
                    testResult.setAttribute(DESIGNER_ATTRIBUTE, testBuilder);
                } else if (this.isRunnerMethod(method)) {
                    testBuilder = this.createTestRunner(method, ctx);
                    testBuilder.groups(testResult.getMethod().getGroups());
                    testResult.setAttribute(RUNNER_ATTRIBUTE, testBuilder);
                } else {
                    throw new CitrusRuntimeException("Missing designer or runner method parameter");
                }
                CitrusAnnotations.injectAll((Object)((Object)this), (Citrus)this.citrus, (TestContext)ctx);
                this.invokeTestMethod(testResult, method, testBuilder.getTestCase(), ctx, invocationCount);
            }
            finally {
                testResult.removeAttribute(DESIGNER_ATTRIBUTE);
                testResult.removeAttribute(RUNNER_ATTRIBUTE);
            }
        }
    }

    protected void invokeTestMethod(ITestResult testResult, Method method, TestCase testCase, TestContext context, int invocationCount) {
        if (testResult.getAttribute(DESIGNER_ATTRIBUTE) != null) {
            super.invokeTestMethod(testResult, method, testCase, context, invocationCount);
        } else if (testResult.getAttribute(RUNNER_ATTRIBUTE) != null) {
            TestRunner testRunner = (TestRunner)testResult.getAttribute(RUNNER_ATTRIBUTE);
            try {
                Object[] params = this.resolveParameter(testResult, method, testCase, context, invocationCount);
                testRunner.start();
                ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])params);
            }
            catch (AssertionError | Exception e) {
                testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
                throw new TestCaseFailedException((Throwable)e);
            }
            finally {
                testRunner.stop();
            }
        }
    }

    protected Object resolveAnnotatedResource(ITestResult testResult, Class<?> parameterType, TestContext context) {
        if (TestDesigner.class.isAssignableFrom(parameterType)) {
            return testResult.getAttribute(DESIGNER_ATTRIBUTE);
        }
        if (TestRunner.class.isAssignableFrom(parameterType)) {
            return testResult.getAttribute(RUNNER_ATTRIBUTE);
        }
        return super.resolveAnnotatedResource(testResult, parameterType, context);
    }

    protected TestDesigner createTestDesigner(Method method, TestContext context) {
        DefaultTestDesigner testDesigner = new DefaultTestDesigner(context);
        testDesigner.testClass(((Object)((Object)this)).getClass());
        testDesigner.packageName(((Object)((Object)this)).getClass().getPackage().getName());
        if (method.getAnnotation(CitrusTest.class) != null) {
            CitrusTest citrusTestAnnotation = method.getAnnotation(CitrusTest.class);
            if (StringUtils.hasText((String)citrusTestAnnotation.name())) {
                testDesigner.name(citrusTestAnnotation.name());
            } else {
                testDesigner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
            }
        } else {
            testDesigner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
        }
        return testDesigner;
    }

    protected TestRunner createTestRunner(Method method, TestContext context) {
        DefaultTestRunner testRunner = new DefaultTestRunner(context);
        testRunner.testClass(((Object)((Object)this)).getClass());
        testRunner.packageName(((Object)((Object)this)).getClass().getPackage().getName());
        if (method.getAnnotation(CitrusTest.class) != null) {
            CitrusTest citrusTestAnnotation = method.getAnnotation(CitrusTest.class);
            if (StringUtils.hasText((String)citrusTestAnnotation.name())) {
                testRunner.name(citrusTestAnnotation.name());
            } else {
                testRunner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
            }
        } else {
            testRunner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
        }
        return testRunner;
    }

    protected boolean isDesignerMethod(Method method) {
        Class<?>[] parameterTypes;
        if (method == null) {
            return false;
        }
        for (Class<TestDesigner> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(TestDesigner.class)) continue;
            return true;
        }
        return false;
    }

    protected boolean isRunnerMethod(Method method) {
        Class<?>[] parameterTypes;
        if (method == null) {
            return false;
        }
        for (Class<TestRunner> clazz : parameterTypes = method.getParameterTypes()) {
            if (!clazz.isAssignableFrom(TestRunner.class)) continue;
            return true;
        }
        return false;
    }
}

