/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.CitrusSettings;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageContentBuilder;
import com.consol.citrus.message.MessageHeaderDataBuilder;
import com.consol.citrus.message.MessagePayloadBuilder;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.message.builder.MarshallingHeaderDataBuilder;
import com.consol.citrus.message.builder.MarshallingPayloadBuilder;
import com.consol.citrus.message.builder.ObjectMappingHeaderDataBuilder;
import com.consol.citrus.message.builder.ObjectMappingPayloadBuilder;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.HeaderValidator;
import com.consol.citrus.validation.MessageValidator;
import com.consol.citrus.validation.builder.DefaultMessageContentBuilder;
import com.consol.citrus.validation.callback.ValidationCallback;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.json.JsonMessageValidationContext;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.json.JsonPathVariableExtractor;
import com.consol.citrus.validation.script.ScriptValidationContext;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.validation.xml.XmlNamespaceAware;
import com.consol.citrus.validation.xml.XpathMessageValidationContext;
import com.consol.citrus.validation.xml.XpathPayloadVariableExtractor;
import com.consol.citrus.variable.MessageHeaderVariableExtractor;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Marshaller;

public class ReceiveMessageActionBuilder<B extends ReceiveMessageActionBuilder<B>>
extends AbstractTestActionBuilder<ReceiveMessageAction, B>
implements ReferenceResolverAware {
    protected final B self;
    private final ReceiveMessageAction.ReceiveMessageActionBuilder<?, ?> delegate;
    private String messageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private XmlMessageValidationContext.XmlValidationContextBuilder<?, ?> xmlMessageValidationContext;
    private JsonMessageValidationContext.Builder jsonMessageValidationContext;
    private JsonPathMessageValidationContext.Builder jsonPathValidationContext;
    private ScriptValidationContext.Builder scriptValidationContext;

    public ReceiveMessageActionBuilder(ReceiveMessageAction.ReceiveMessageActionBuilder<?, ?> builder) {
        this.self = this;
        this.delegate = builder;
    }

    public B endpoint(Endpoint messageEndpoint) {
        this.delegate.endpoint(messageEndpoint);
        return this.self;
    }

    public B endpoint(String messageEndpointUri) {
        this.delegate.endpoint(messageEndpointUri);
        return this.self;
    }

    public B timeout(long receiveTimeout) {
        this.delegate.timeout(receiveTimeout);
        return this.self;
    }

    public B messageBuilder(DefaultMessageContentBuilder messageBuilder) {
        this.delegate.message((MessageContentBuilder)messageBuilder);
        return this.self;
    }

    public B message(Message controlMessage) {
        this.delegate.message(controlMessage);
        return this.self;
    }

    public B messageName(String name) {
        this.delegate.messageName(name);
        return this.self;
    }

    public B payload(String payload) {
        this.delegate.payload(payload);
        return this.self;
    }

    public B payload(Resource payloadResource) {
        return this.payload(payloadResource, FileUtils.getDefaultCharset());
    }

    public B payload(Resource payloadResource, Charset charset) {
        this.delegate.payload(payloadResource, charset);
        return this.self;
    }

    public B payload(Object payload, Marshaller marshaller) {
        this.delegate.payload((MessagePayloadBuilder)new MarshallingPayloadBuilder(payload, marshaller));
        return this.self;
    }

    public B payload(Object payload, ObjectMapper objectMapper) {
        this.delegate.payload((MessagePayloadBuilder)new ObjectMappingPayloadBuilder(payload, objectMapper));
        return this.self;
    }

    public B payloadModel(Object payload) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            this.delegate.payload((MessagePayloadBuilder)new ObjectMappingPayloadBuilder(payload));
        } else {
            this.delegate.payload((MessagePayloadBuilder)new MarshallingPayloadBuilder(payload));
        }
        return this.self;
    }

    public B payload(Object payload, String mapperOrMarshallerName) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            this.delegate.payload((MessagePayloadBuilder)new ObjectMappingPayloadBuilder(payload, mapperOrMarshallerName));
        } else {
            this.delegate.payload((MessagePayloadBuilder)new MarshallingPayloadBuilder(payload, mapperOrMarshallerName));
        }
        return this.self;
    }

    public B header(String name, Object value) {
        this.delegate.header(name, value);
        return this.self;
    }

    public B headers(Map<String, Object> headers) {
        this.delegate.headers(headers);
        return this.self;
    }

    public B header(String data) {
        this.delegate.header(data);
        return this.self;
    }

    public B headerFragment(Object model) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            this.delegate.header((MessageHeaderDataBuilder)new ObjectMappingHeaderDataBuilder(model));
        } else {
            this.delegate.header((MessageHeaderDataBuilder)new MarshallingHeaderDataBuilder(model));
        }
        return this.self;
    }

    public B headerFragment(Object model, String mapperOrMarshallerName) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            this.delegate.header((MessageHeaderDataBuilder)new ObjectMappingHeaderDataBuilder(model, mapperOrMarshallerName));
        } else {
            this.delegate.header((MessageHeaderDataBuilder)new MarshallingHeaderDataBuilder(model, mapperOrMarshallerName));
        }
        return this.self;
    }

    public B headerFragment(Object model, Marshaller marshaller) {
        this.delegate.header((MessageHeaderDataBuilder)new MarshallingHeaderDataBuilder(model, marshaller));
        return this.self;
    }

    public B headerFragment(Object model, ObjectMapper objectMapper) {
        this.delegate.header((MessageHeaderDataBuilder)new ObjectMappingHeaderDataBuilder(model, objectMapper));
        return this.self;
    }

    public B header(Resource resource) {
        return this.header(resource, FileUtils.getDefaultCharset());
    }

    public B header(Resource resource, Charset charset) {
        this.delegate.header(resource, charset);
        return this.self;
    }

    public B headerNameIgnoreCase(boolean value) {
        this.delegate.headerNameIgnoreCase(value);
        return this.self;
    }

    public B validateScript(String validationScript) {
        this.getScriptValidationContext().script(validationScript);
        return this.self;
    }

    public B validateScript(Resource scriptResource) {
        return this.validateScript(scriptResource, FileUtils.getDefaultCharset());
    }

    public B validateScript(Resource scriptResource, Charset charset) {
        try {
            this.validateScript(FileUtils.readToString((Resource)scriptResource, (Charset)charset));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read script resource file", (Throwable)e);
        }
        return this.self;
    }

    public B validateScriptResource(String fileResourcePath) {
        this.getScriptValidationContext().scriptResource(fileResourcePath);
        return this.self;
    }

    public B validateScriptType(String type) {
        this.getScriptValidationContext().scriptType(type);
        return this.self;
    }

    public B messageType(MessageType messageType) {
        this.messageType(messageType.name());
        return this.self;
    }

    public B messageType(String messageType) {
        this.messageType = messageType;
        this.delegate.messageType(messageType);
        if (MessageType.JSON.name().equalsIgnoreCase(messageType)) {
            this.getJsonMessageValidationContext();
        }
        if (MessageType.XML.name().equalsIgnoreCase(messageType) || MessageType.XHTML.name().equalsIgnoreCase(messageType)) {
            this.getXmlMessageValidationContext();
        }
        return this.self;
    }

    public B validationContext(ValidationContext.Builder<?, ?> validationContext) {
        this.delegate.validate(validationContext);
        return this.self;
    }

    public B validationContext(ValidationContext validationContext) {
        this.delegate.validate(validationContext);
        return this.self;
    }

    public B validationContexts(List<ValidationContext> validationContexts) {
        validationContexts.forEach(this::validationContext);
        return this.self;
    }

    public B schemaValidation(boolean enabled) {
        this.getXmlMessageValidationContext().schemaValidation(enabled);
        this.getJsonMessageValidationContext().schemaValidation(enabled);
        return this.self;
    }

    public B validateNamespace(String prefix, String namespaceUri) {
        this.getXmlMessageValidationContext().namespace(prefix, namespaceUri);
        return this.self;
    }

    public B validate(String path, Object controlValue) {
        if (JsonPathMessageValidationContext.isJsonPathExpression((String)path)) {
            this.getJsonPathValidationContext().expression(path, controlValue);
        } else {
            this.getXPathValidationContext().expression(path, controlValue);
        }
        return this.self;
    }

    public B validate(Map<String, Object> map) {
        map.forEach(this::validate);
        return this.self;
    }

    public B ignore(String path) {
        if (this.messageType.equalsIgnoreCase(MessageType.XML.name()) || this.messageType.equalsIgnoreCase(MessageType.XHTML.name())) {
            this.getXmlMessageValidationContext().ignore(path);
        } else if (this.messageType.equalsIgnoreCase(MessageType.JSON.name())) {
            this.getJsonMessageValidationContext().ignore(path);
        }
        return this.self;
    }

    public B xpath(String xPathExpression, Object controlValue) {
        this.getXPathValidationContext().expression(xPathExpression, controlValue);
        return this.self;
    }

    public B jsonPath(String jsonPathExpression, Object controlValue) {
        this.getJsonPathValidationContext().expression(jsonPathExpression, controlValue);
        return this.self;
    }

    public B xsd(String schemaName) {
        this.getXmlMessageValidationContext().schema(schemaName);
        return this.self;
    }

    public B jsonSchema(String schemaName) {
        this.getJsonMessageValidationContext().schema(schemaName);
        return this.self;
    }

    public B xsdSchemaRepository(String schemaRepository) {
        this.getXmlMessageValidationContext().schemaRepository(schemaRepository);
        return this.self;
    }

    public B jsonSchemaRepository(String schemaRepository) {
        this.getJsonMessageValidationContext().schemaRepository(schemaRepository);
        return this.self;
    }

    public B namespace(String prefix, String namespaceUri) {
        this.getXmlMessageValidationContext().namespaceContext(prefix, namespaceUri);
        this.namespaces.put(prefix, namespaceUri);
        return this.self;
    }

    public B namespaces(Map<String, String> namespaceMappings) {
        this.getXmlMessageValidationContext().namespaceContext(namespaceMappings);
        this.namespaces.putAll(namespaceMappings);
        return this.self;
    }

    public B selector(String messageSelector) {
        this.delegate.selector(messageSelector);
        return this.self;
    }

    public B selector(Map<String, String> messageSelector) {
        this.delegate.selector(messageSelector);
        return this.self;
    }

    public B extractFromHeader(String headerName, String variable) {
        this.variableExtractor((VariableExtractor)MessageHeaderVariableExtractor.Builder.headerValueExtractor().header(headerName, variable).build());
        return this.self;
    }

    public B extractFromPayload(String path, String variable) {
        if (JsonPathMessageValidationContext.isJsonPathExpression((String)path)) {
            this.variableExtractor((VariableExtractor)JsonPathVariableExtractor.Builder.jsonPathExtractor().expression(path, variable).build());
        } else {
            this.variableExtractor((VariableExtractor)XpathPayloadVariableExtractor.Builder.xpathExtractor().expression(path, variable).build());
        }
        return this.self;
    }

    public B validator(MessageValidator<? extends ValidationContext> validator) {
        this.delegate.validator(validator);
        return this.self;
    }

    public B validators(MessageValidator<? extends ValidationContext> ... validators) {
        return this.validators(Arrays.asList(validators));
    }

    public B validators(List<MessageValidator<? extends ValidationContext>> validators) {
        this.delegate.validators(validators);
        return this.self;
    }

    public B validator(String ... validatorNames) {
        this.delegate.validator(validatorNames);
        return this.self;
    }

    public B headerValidator(HeaderValidator ... validators) {
        this.delegate.validator(validators);
        return this.self;
    }

    public B headerValidator(String ... validatorNames) {
        this.delegate.validator(validatorNames);
        return this.self;
    }

    public B dictionary(DataDictionary<?> dictionary) {
        this.delegate.dictionary(dictionary);
        return this.self;
    }

    public B dictionary(String dictionaryName) {
        this.delegate.dictionary(dictionaryName);
        return this.self;
    }

    public B validationCallback(ValidationCallback callback) {
        this.delegate.validationCallback(callback);
        return this.self;
    }

    public B variableExtractor(VariableExtractor extractor) {
        if (extractor instanceof XmlNamespaceAware) {
            ((XmlNamespaceAware)extractor).setNamespaces(this.namespaces);
        }
        this.delegate.process((MessageProcessor)extractor);
        return this.self;
    }

    public B variableExtractor(VariableExtractor.Builder<?, ?> builder) {
        return this.variableExtractor(builder.build());
    }

    public B withReferenceResolver(ReferenceResolver referenceResolver) {
        this.delegate.withReferenceResolver(referenceResolver);
        return this.self;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.delegate.setReferenceResolver(referenceResolver);
    }

    public final ReceiveMessageAction build() {
        return this.delegate.build();
    }

    private XpathMessageValidationContext.Builder getXPathValidationContext() {
        if (this.getXmlMessageValidationContext() instanceof XpathMessageValidationContext.Builder) {
            return (XpathMessageValidationContext.Builder)this.getXmlMessageValidationContext();
        }
        XmlMessageValidationContext context = (XmlMessageValidationContext)this.getXmlMessageValidationContext().build();
        XpathMessageValidationContext.Builder xPathContext = new XpathMessageValidationContext.Builder();
        xPathContext.setNamespaces(context.getNamespaces());
        context.getControlNamespaces().forEach((arg_0, arg_1) -> ((XpathMessageValidationContext.Builder)xPathContext).namespace(arg_0, arg_1));
        context.getIgnoreExpressions().forEach(arg_0 -> ((XpathMessageValidationContext.Builder)xPathContext).ignore(arg_0));
        xPathContext.schema(context.getSchema());
        xPathContext.schemaRepository(context.getSchemaRepository());
        xPathContext.schemaValidation(context.isSchemaValidationEnabled());
        xPathContext.dtd(context.getDTDResource());
        this.delegate.getValidationContextBuilders().remove(this.getXmlMessageValidationContext());
        this.delegate.validate((ValidationContext.Builder)xPathContext);
        this.xmlMessageValidationContext = xPathContext;
        return xPathContext;
    }

    protected XmlMessageValidationContext.XmlValidationContextBuilder<?, ?> getXmlMessageValidationContext() {
        if (this.xmlMessageValidationContext == null) {
            this.xmlMessageValidationContext = new XmlMessageValidationContext.Builder();
            this.delegate.validate(this.xmlMessageValidationContext);
        }
        return this.xmlMessageValidationContext;
    }

    private JsonMessageValidationContext.Builder getJsonMessageValidationContext() {
        if (this.jsonMessageValidationContext == null) {
            this.jsonMessageValidationContext = new JsonMessageValidationContext.Builder();
            this.delegate.validate((ValidationContext.Builder)this.jsonMessageValidationContext);
        }
        return this.jsonMessageValidationContext;
    }

    private ScriptValidationContext.Builder getScriptValidationContext() {
        if (this.scriptValidationContext == null) {
            this.scriptValidationContext = new ScriptValidationContext.Builder();
            this.delegate.validate((ValidationContext.Builder)this.scriptValidationContext);
        }
        return this.scriptValidationContext;
    }

    private JsonPathMessageValidationContext.Builder getJsonPathValidationContext() {
        if (this.jsonPathValidationContext == null) {
            this.jsonPathValidationContext = new JsonPathMessageValidationContext.Builder();
            this.delegate.validate((ValidationContext.Builder)this.jsonPathValidationContext);
        }
        return this.jsonPathValidationContext;
    }
}

