/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.builder;

import com.consol.citrus.AbstractTestActionBuilder;
import com.consol.citrus.CitrusSettings;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.dsl.JsonPathSupport;
import com.consol.citrus.dsl.MessageSupport;
import com.consol.citrus.dsl.XpathSupport;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageBuilder;
import com.consol.citrus.message.MessageHeaderDataBuilder;
import com.consol.citrus.message.MessagePayloadBuilder;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.message.builder.MarshallingHeaderDataBuilder;
import com.consol.citrus.message.builder.MarshallingPayloadBuilder;
import com.consol.citrus.message.builder.ObjectMappingHeaderDataBuilder;
import com.consol.citrus.message.builder.ObjectMappingPayloadBuilder;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.interceptor.BinaryMessageProcessor;
import com.consol.citrus.validation.interceptor.GzipMessageProcessor;
import com.consol.citrus.validation.json.JsonPathMessageProcessor;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.xml.XpathMessageProcessor;
import com.consol.citrus.variable.VariableExtractor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.oxm.Marshaller;

public class SendMessageActionBuilder<B extends SendMessageActionBuilder<B>>
extends AbstractTestActionBuilder<SendMessageAction, B> {
    protected final B self;
    private final SendMessageAction.SendMessageActionBuilder<?, ?, ?> delegate;
    private String messageType = CitrusSettings.DEFAULT_MESSAGE_TYPE;
    private final GzipMessageProcessor gzipMessageProcessor = new GzipMessageProcessor();
    private final BinaryMessageProcessor binaryMessageProcessor = new BinaryMessageProcessor();
    private XpathMessageProcessor xpathMessageProcessor;
    private JsonPathMessageProcessor jsonPathMessageProcessor;

    public SendMessageActionBuilder() {
        this((SendMessageAction.SendMessageActionBuilder<?, ?, ?>)new SendMessageAction.Builder());
    }

    public SendMessageActionBuilder(SendMessageAction.SendMessageActionBuilder<?, ?, ?> builder) {
        this.self = this;
        this.delegate = builder;
    }

    public B endpoint(Endpoint messageEndpoint) {
        this.delegate.endpoint(messageEndpoint);
        return this.self;
    }

    public B endpoint(String messageEndpointUri) {
        this.delegate.endpoint(messageEndpointUri);
        return this.self;
    }

    public B fork(boolean forkMode) {
        this.delegate.fork(forkMode);
        return this.self;
    }

    public B messageBuilder(MessageBuilder messageBuilder) {
        this.delegate.message(messageBuilder);
        return this.self;
    }

    public B message(Message message) {
        this.delegate.message(message);
        return this.self;
    }

    public B messageName(String name) {
        this.delegate.message().name(name);
        return this.self;
    }

    public B payload(String payload) {
        this.delegate.message().body(payload);
        return this.self;
    }

    public B payload(Resource payloadResource) {
        return this.payload(payloadResource, FileUtils.getDefaultCharset());
    }

    public B payload(Resource payloadResource, Charset charset) {
        this.delegate.message().body(payloadResource, charset);
        return this.self;
    }

    public B payload(Object payload, Marshaller marshaller) {
        this.delegate.message().body((MessagePayloadBuilder)new MarshallingPayloadBuilder(payload, marshaller));
        return this.self;
    }

    public B payload(Object payload, ObjectMapper objectMapper) {
        this.delegate.message().body((MessagePayloadBuilder)new ObjectMappingPayloadBuilder(payload, objectMapper));
        return this.self;
    }

    public B payloadModel(Object payload) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            this.delegate.message().body((MessagePayloadBuilder)new ObjectMappingPayloadBuilder(payload));
        } else {
            this.delegate.message().body((MessagePayloadBuilder)new MarshallingPayloadBuilder(payload));
        }
        return this.self;
    }

    public B payload(Object payload, String mapperOrMarshallerName) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            this.delegate.message().body((MessagePayloadBuilder)new ObjectMappingPayloadBuilder(payload, mapperOrMarshallerName));
        } else {
            this.delegate.message().body((MessagePayloadBuilder)new MarshallingPayloadBuilder(payload, mapperOrMarshallerName));
        }
        return this.self;
    }

    public B header(String name, Object value) {
        this.delegate.message().header(name, value);
        return this.self;
    }

    public B headers(Map<String, Object> headers) {
        this.delegate.message().headers(headers);
        return this.self;
    }

    public B header(String data) {
        this.delegate.message().header(data);
        return this.self;
    }

    public B header(Resource resource) {
        return this.header(resource, FileUtils.getDefaultCharset());
    }

    public B header(Resource resource, Charset charset) {
        this.delegate.message().header(resource, charset);
        return this.self;
    }

    public B headerFragment(Object model, Marshaller marshaller) {
        this.delegate.message().header((MessageHeaderDataBuilder)new MarshallingHeaderDataBuilder(model, marshaller));
        return this.self;
    }

    public B headerFragment(Object model, ObjectMapper objectMapper) {
        this.delegate.message().header((MessageHeaderDataBuilder)new ObjectMappingHeaderDataBuilder(model, objectMapper));
        return this.self;
    }

    public B headerFragment(Object model) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            this.delegate.message().header((MessageHeaderDataBuilder)new ObjectMappingHeaderDataBuilder(model));
        } else {
            this.delegate.message().header((MessageHeaderDataBuilder)new MarshallingHeaderDataBuilder(model));
        }
        return this.self;
    }

    public B headerFragment(Object model, String mapperOrMarshallerName) {
        if (MessageType.JSON.name().equalsIgnoreCase(this.messageType)) {
            this.delegate.message().header((MessageHeaderDataBuilder)new ObjectMappingHeaderDataBuilder(model, mapperOrMarshallerName));
        } else {
            this.delegate.message().header((MessageHeaderDataBuilder)new MarshallingHeaderDataBuilder(model, mapperOrMarshallerName));
        }
        return this.self;
    }

    public B messageType(MessageType messageType) {
        this.messageType(messageType.name());
        return this.self;
    }

    public B messageType(String messageType) {
        this.messageType = messageType;
        this.delegate.message().type(messageType);
        if (MessageType.BINARY.name().equalsIgnoreCase(messageType)) {
            this.delegate.process((MessageProcessor)this.binaryMessageProcessor);
        }
        if (MessageType.GZIP.name().equalsIgnoreCase(messageType)) {
            this.delegate.process((MessageProcessor)this.gzipMessageProcessor);
        }
        return this.self;
    }

    public B extractFromHeader(String headerName, String variable) {
        this.variableExtractor((VariableExtractor)new MessageSupport().headers().expression(headerName, (Object)variable).build());
        return this.self;
    }

    public B extractFromPayload(String path, String variable) {
        if (JsonPathMessageValidationContext.isJsonPathExpression((String)path)) {
            this.variableExtractor(new JsonPathSupport().expression(path, (Object)variable).asExtractor());
        } else {
            this.variableExtractor(new XpathSupport().expression(path, (Object)variable).asExtractor());
        }
        return this.self;
    }

    public B variableExtractor(VariableExtractor extractor) {
        this.delegate.process((MessageProcessor)extractor);
        return this.self;
    }

    public B xpath(String expression, String value) {
        if (this.xpathMessageProcessor == null) {
            this.xpathMessageProcessor = new XpathMessageProcessor();
            this.delegate.process((MessageProcessor)this.xpathMessageProcessor);
        }
        this.xpathMessageProcessor.getXPathExpressions().put(expression, value);
        return this.self;
    }

    public B jsonPath(String expression, String value) {
        if (this.jsonPathMessageProcessor == null) {
            this.jsonPathMessageProcessor = new JsonPathMessageProcessor();
            this.delegate.process((MessageProcessor)this.jsonPathMessageProcessor);
        }
        this.jsonPathMessageProcessor.getJsonPathExpressions().put(expression, value);
        return this.self;
    }

    public B withReferenceResolver(ReferenceResolver referenceResolver) {
        this.delegate.withReferenceResolver(referenceResolver);
        return this.self;
    }

    public B dictionary(DataDictionary<?> dictionary) {
        this.delegate.message().dictionary(dictionary);
        return this.self;
    }

    public B dictionary(String dictionaryName) {
        this.delegate.message().dictionary(dictionaryName);
        return this.self;
    }

    public SendMessageAction build() {
        return this.delegate.build();
    }
}

