/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.dsl.runner;

import com.consol.citrus.AbstractTestContainerBuilder;
import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestActionContainerBuilder;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.actions.AntRunAction;
import com.consol.citrus.actions.CreateVariablesAction;
import com.consol.citrus.actions.EchoAction;
import com.consol.citrus.actions.ExecutePLSQLAction;
import com.consol.citrus.actions.ExecuteSQLAction;
import com.consol.citrus.actions.ExecuteSQLQueryAction;
import com.consol.citrus.actions.FailAction;
import com.consol.citrus.actions.InputAction;
import com.consol.citrus.actions.LoadPropertiesAction;
import com.consol.citrus.actions.PurgeEndpointAction;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.actions.ReceiveTimeoutAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.actions.SleepAction;
import com.consol.citrus.actions.StartServerAction;
import com.consol.citrus.actions.StopServerAction;
import com.consol.citrus.actions.StopTimeAction;
import com.consol.citrus.actions.StopTimerAction;
import com.consol.citrus.actions.TraceVariablesAction;
import com.consol.citrus.actions.TransformAction;
import com.consol.citrus.condition.ActionCondition;
import com.consol.citrus.condition.Condition;
import com.consol.citrus.condition.FileCondition;
import com.consol.citrus.condition.HttpCondition;
import com.consol.citrus.container.Assert;
import com.consol.citrus.container.Async;
import com.consol.citrus.container.Catch;
import com.consol.citrus.container.Conditional;
import com.consol.citrus.container.FinallySequence;
import com.consol.citrus.container.Iterate;
import com.consol.citrus.container.Parallel;
import com.consol.citrus.container.RepeatOnErrorUntilTrue;
import com.consol.citrus.container.RepeatUntilTrue;
import com.consol.citrus.container.Sequence;
import com.consol.citrus.container.Template;
import com.consol.citrus.container.TestActionContainer;
import com.consol.citrus.container.Timer;
import com.consol.citrus.container.Wait;
import com.consol.citrus.container.WaitActionConditionBuilder;
import com.consol.citrus.container.WaitFileConditionBuilder;
import com.consol.citrus.container.WaitHttpConditionBuilder;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.dsl.builder.AssertSoapFaultBuilder;
import com.consol.citrus.dsl.builder.BuilderSupport;
import com.consol.citrus.dsl.builder.CamelRouteActionBuilder;
import com.consol.citrus.dsl.builder.DockerExecuteActionBuilder;
import com.consol.citrus.dsl.builder.HttpActionBuilder;
import com.consol.citrus.dsl.builder.KubernetesExecuteActionBuilder;
import com.consol.citrus.dsl.builder.PurgeJmsQueuesActionBuilder;
import com.consol.citrus.dsl.builder.PurgeMessageChannelActionBuilder;
import com.consol.citrus.dsl.builder.ReceiveMessageActionBuilder;
import com.consol.citrus.dsl.builder.SeleniumActionBuilder;
import com.consol.citrus.dsl.builder.SendMessageActionBuilder;
import com.consol.citrus.dsl.builder.SoapActionBuilder;
import com.consol.citrus.dsl.builder.ZooExecuteActionBuilder;
import com.consol.citrus.dsl.runner.ApplyTestBehaviorAction;
import com.consol.citrus.dsl.runner.TestBehavior;
import com.consol.citrus.dsl.runner.TestRunner;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.script.GroovyAction;
import com.consol.citrus.server.Server;
import java.io.File;
import java.util.Date;
import java.util.Stack;

public class DefaultTestRunner
implements TestRunner {
    private final DefaultTestCase testCase;
    private TestContext context;
    protected Stack<TestActionContainerBuilder<? extends TestActionContainer, ?>> containers = new Stack();

    public DefaultTestRunner() {
        this.testCase = new DefaultTestCase();
        this.testClass(this.getClass());
        this.name(this.getClass().getSimpleName());
        this.packageName(this.getClass().getPackage().getName());
    }

    protected DefaultTestRunner(DefaultTestCase testCase) {
        this.testCase = testCase;
    }

    public DefaultTestRunner(TestContext context) {
        this();
        this.context = context;
    }

    public void testClass(Class<?> type) {
        this.testCase.setTestClass(type);
    }

    public void name(String name) {
        this.testCase.setName(name);
    }

    public void description(String description) {
        this.testCase.setDescription(description);
    }

    public void author(String author) {
        this.testCase.getMetaInfo().setAuthor(author);
    }

    public void packageName(String packageName) {
        this.testCase.setPackageName(packageName);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.testCase.getMetaInfo().setStatus(status);
    }

    public void creationDate(Date date) {
        this.testCase.getMetaInfo().setCreationDate(date);
    }

    public void groups(String[] groups) {
        this.testCase.setGroups(groups);
    }

    @Override
    public void start() {
        this.testCase.start(this.context);
    }

    @Override
    public void stop() {
        this.testCase.finish(this.context);
    }

    public <T> T variable(String name, T value) {
        this.testCase.getVariableDefinitions().put(name, value);
        if (value instanceof String) {
            String resolved = this.context.replaceDynamicContentInString(value.toString());
            this.context.setVariable(name, (Object)resolved);
            return (T)resolved;
        }
        this.context.setVariable(name, value);
        return value;
    }

    @Override
    public <A extends TestAction> TestActionBuilder<A> run(A testAction) {
        return this.run(() -> testAction);
    }

    @Override
    public <T extends TestActionBuilder<?>> T run(T builder) {
        if (builder instanceof TestActionContainerBuilder) {
            if (!((TestActionContainerBuilder)this.containers.lastElement()).equals(builder)) {
                throw new CitrusRuntimeException("Invalid use of action containers - the container execution is not expected!");
            }
            this.containers.pop();
            if (builder instanceof FinallySequence.Builder) {
                ((FinallySequence.Builder)builder).getActions().forEach(arg_0 -> ((DefaultTestCase)this.testCase).addFinalAction(arg_0));
                return builder;
            }
        }
        if (this.containers.isEmpty()) {
            this.testCase.addTestAction(builder);
            this.testCase.executeAction(builder.build(), this.context);
        } else {
            ((TestActionContainerBuilder)this.containers.lastElement()).getActions().add(builder);
        }
        return builder;
    }

    @Override
    public ApplyTestBehaviorAction.Builder applyBehavior(TestBehavior behavior) {
        ApplyTestBehaviorAction.Builder builder = new ApplyTestBehaviorAction.Builder().runner(this).behavior(behavior);
        behavior.setTestContext(this.context);
        builder.build().execute(this.context);
        return builder;
    }

    @Override
    public <T extends TestActionContainer, B extends TestActionContainerBuilder<T, B>> TestActionContainerBuilder<T, B> container(final T container) {
        AbstractTestContainerBuilder builder = new AbstractTestContainerBuilder<T, B>(){

            public B actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run(super.actions(actions));
            }

            protected T doBuild() {
                return container;
            }

            public T build() {
                if (container.getActions().size() > 0) {
                    return container;
                }
                return super.build();
            }
        };
        return this.container((T)builder);
    }

    @Override
    public <T extends TestActionContainerBuilder<? extends TestActionContainer, ?>> T container(T container) {
        this.containers.push(container);
        return container;
    }

    @Override
    public CreateVariablesAction.Builder createVariable(String variableName, String value) {
        CreateVariablesAction.Builder builder = CreateVariablesAction.Builder.createVariable((String)variableName, (String)value);
        return this.run(builder);
    }

    @Override
    public AntRunAction.Builder antrun(BuilderSupport<AntRunAction.Builder> configurer) {
        AntRunAction.Builder builder = new AntRunAction.Builder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public EchoAction.Builder echo(String message) {
        return this.run(new EchoAction.Builder().message(message));
    }

    @Override
    public ExecutePLSQLAction.Builder plsql(BuilderSupport<ExecutePLSQLAction.Builder> configurer) {
        ExecutePLSQLAction.Builder builder = new ExecutePLSQLAction.Builder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public ExecuteSQLAction.Builder sql(BuilderSupport<ExecuteSQLAction.Builder> configurer) {
        ExecuteSQLAction.Builder builder = new ExecuteSQLAction.Builder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public ExecuteSQLQueryAction.Builder query(BuilderSupport<ExecuteSQLQueryAction.Builder> configurer) {
        ExecuteSQLQueryAction.Builder builder = new ExecuteSQLQueryAction.Builder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public FailAction.Builder fail(String message) {
        return this.run(new FailAction.Builder().message(message));
    }

    @Override
    public InputAction.Builder input(BuilderSupport<InputAction.Builder> configurer) {
        InputAction.Builder builder = new InputAction.Builder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public ReceiveTimeoutAction.Builder receiveTimeout(BuilderSupport<ReceiveTimeoutAction.Builder> configurer) {
        ReceiveTimeoutAction.Builder builder = new ReceiveTimeoutAction.Builder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public LoadPropertiesAction.Builder load(String filePath) {
        LoadPropertiesAction.Builder builder = new LoadPropertiesAction.Builder().filePath(filePath);
        return this.run(builder);
    }

    @Override
    public PurgeJmsQueuesActionBuilder purgeQueues(BuilderSupport<PurgeJmsQueuesActionBuilder> configurer) {
        PurgeJmsQueuesActionBuilder builder = new PurgeJmsQueuesActionBuilder();
        builder.withReferenceResolver(this.context.getReferenceResolver());
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public PurgeMessageChannelActionBuilder purgeChannels(BuilderSupport<PurgeMessageChannelActionBuilder> configurer) {
        PurgeMessageChannelActionBuilder builder = new PurgeMessageChannelActionBuilder();
        builder.channelResolver(this.context.getReferenceResolver());
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public PurgeEndpointAction.Builder purgeEndpoints(BuilderSupport<PurgeEndpointAction.Builder> configurer) {
        PurgeEndpointAction.Builder builder = new PurgeEndpointAction.Builder().withReferenceResolver(this.context.getReferenceResolver());
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public ReceiveMessageActionBuilder<?> receive(BuilderSupport<ReceiveMessageActionBuilder<?>> configurer) {
        ReceiveMessageActionBuilder builder = new ReceiveMessageActionBuilder(new ReceiveMessageAction.Builder().withReferenceResolver(this.context.getReferenceResolver()));
        configurer.configure(builder);
        return this.run((TestActionBuilder)builder);
    }

    @Override
    public SendMessageActionBuilder<?> send(BuilderSupport<SendMessageActionBuilder<?>> configurer) {
        SendMessageActionBuilder builder = new SendMessageActionBuilder(new SendMessageAction.Builder().withReferenceResolver(this.context.getReferenceResolver()));
        configurer.configure(builder);
        return this.run((TestActionBuilder)builder);
    }

    @Override
    public SleepAction.Builder sleep() {
        return this.run(new SleepAction.Builder());
    }

    @Override
    public SleepAction.Builder sleep(long milliseconds) {
        SleepAction.Builder builder = new SleepAction.Builder().milliseconds(milliseconds);
        return this.run(builder);
    }

    @Override
    public Wait.Builder waitFor() {
        return new Wait.Builder(){

            public WaitActionConditionBuilder execution() {
                final Sequence.Builder dummy = new Sequence.Builder();
                ActionCondition condition = new ActionCondition();
                this.condition = condition;
                DefaultTestRunner.this.containers.push((TestActionContainerBuilder<TestActionContainer, ?>)dummy);
                return new WaitActionConditionBuilder(condition, this){

                    public WaitActionConditionBuilder action(TestActionBuilder<?> action) {
                        super.action(action);
                        DefaultTestRunner.this.containers.remove(dummy);
                        return DefaultTestRunner.this.run(this);
                    }
                };
            }

            public WaitFileConditionBuilder file() {
                FileCondition condition = new FileCondition();
                this.condition = condition;
                return new WaitFileConditionBuilder(condition, this){

                    public WaitFileConditionBuilder resource(File file) {
                        super.resource(file);
                        return DefaultTestRunner.this.run(this);
                    }
                };
            }

            public WaitHttpConditionBuilder http() {
                HttpCondition condition = new HttpCondition();
                this.condition = condition;
                return new WaitHttpConditionBuilder(condition, this){

                    public WaitHttpConditionBuilder url(String requestUrl) {
                        super.url(requestUrl);
                        return DefaultTestRunner.this.run(this);
                    }
                };
            }

            public Wait.Builder condition(Condition condition) {
                super.condition(condition);
                return DefaultTestRunner.this.run(this);
            }
        };
    }

    @Override
    public StartServerAction.Builder start(Server ... servers) {
        StartServerAction.Builder builder = new StartServerAction.Builder().server(servers);
        return this.run(builder);
    }

    @Override
    public StartServerAction.Builder start(Server server) {
        StartServerAction.Builder builder = new StartServerAction.Builder().server(server);
        return this.run(builder);
    }

    @Override
    public StopServerAction.Builder stop(Server ... servers) {
        StopServerAction.Builder builder = new StopServerAction.Builder().server(servers);
        return this.run(builder);
    }

    @Override
    public StopServerAction.Builder stop(Server server) {
        StopServerAction.Builder builder = new StopServerAction.Builder().server(new Server[]{server});
        return this.run(builder);
    }

    @Override
    public StopTimeAction.Builder stopTime() {
        return this.run(new StopTimeAction.Builder());
    }

    @Override
    public StopTimeAction.Builder stopTime(String id) {
        StopTimeAction.Builder builder = new StopTimeAction.Builder().id(id);
        return this.run(builder);
    }

    @Override
    public StopTimeAction.Builder stopTime(String id, String suffix) {
        StopTimeAction.Builder builder = new StopTimeAction.Builder().id(id).suffix(suffix);
        return this.run(builder);
    }

    @Override
    public TraceVariablesAction.Builder traceVariables() {
        return this.run(new TraceVariablesAction.Builder());
    }

    @Override
    public TraceVariablesAction.Builder traceVariables(String ... variables) {
        TraceVariablesAction.Builder builder = new TraceVariablesAction.Builder().variables(variables);
        return this.run(builder);
    }

    @Override
    public GroovyAction.Builder groovy(BuilderSupport<GroovyAction.Builder> configurer) {
        GroovyAction.Builder builder = new GroovyAction.Builder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public TransformAction.Builder transform(BuilderSupport<TransformAction.Builder> configurer) {
        TransformAction.Builder builder = new TransformAction.Builder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public Assert.Builder assertException() {
        Assert.Builder builder = new Assert.Builder(){

            public Assert.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run(super.actions(actions));
            }
        };
        return this.container(builder);
    }

    @Override
    public Catch.Builder catchException() {
        Catch.Builder builder = new Catch.Builder(){

            public Catch.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run((Catch.Builder)super.actions(actions));
            }
        };
        return this.container(builder);
    }

    @Override
    public AssertSoapFaultBuilder assertSoapFault() {
        AssertSoapFaultBuilder builder = new AssertSoapFaultBuilder(){

            @Override
            public AssertSoapFaultBuilder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run(super.actions(actions));
            }
        };
        builder.withReferenceResolver(this.context.getReferenceResolver());
        return this.container(builder);
    }

    @Override
    public Conditional.Builder conditional() {
        Conditional.Builder builder = new Conditional.Builder(){

            public Conditional.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run((Conditional.Builder)super.actions(actions));
            }
        };
        return this.container(builder);
    }

    @Override
    public Iterate.Builder iterate() {
        Iterate.Builder builder = new Iterate.Builder(){

            public Iterate.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run((Iterate.Builder)super.actions(actions));
            }
        };
        return this.container(builder);
    }

    @Override
    public Parallel.Builder parallel() {
        Parallel.Builder builder = new Parallel.Builder(){

            public Parallel.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run((Parallel.Builder)super.actions(actions));
            }
        };
        return this.container(builder);
    }

    @Override
    public RepeatOnErrorUntilTrue.Builder repeatOnError() {
        RepeatOnErrorUntilTrue.Builder builder = new RepeatOnErrorUntilTrue.Builder(){

            public RepeatOnErrorUntilTrue.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run((RepeatOnErrorUntilTrue.Builder)super.actions(actions));
            }
        };
        return this.container(builder);
    }

    @Override
    public RepeatUntilTrue.Builder repeat() {
        RepeatUntilTrue.Builder builder = new RepeatUntilTrue.Builder(){

            public RepeatUntilTrue.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run((RepeatUntilTrue.Builder)super.actions(actions));
            }
        };
        return this.container(builder);
    }

    @Override
    public Sequence.Builder sequential() {
        Sequence.Builder builder = new Sequence.Builder(){

            public Sequence.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run((Sequence.Builder)super.actions(actions));
            }
        };
        return this.container(builder);
    }

    @Override
    public Async.Builder async() {
        Async.Builder builder = new Async.Builder(){

            public Async.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run((Async.Builder)super.actions(actions));
            }
        };
        return this.container(builder);
    }

    @Override
    public Timer.Builder timer() {
        Timer.Builder builder = new Timer.Builder(){

            public Timer.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run((Timer.Builder)super.actions(actions));
            }
        };
        return this.container(builder);
    }

    @Override
    public StopTimerAction.Builder stopTimer(String timerId) {
        StopTimerAction.Builder builder = new StopTimerAction.Builder().id(timerId);
        return this.run(builder);
    }

    @Override
    public StopTimerAction.Builder stopTimers() {
        return this.run(new StopTimerAction.Builder());
    }

    @Override
    public DockerExecuteActionBuilder docker(BuilderSupport<DockerExecuteActionBuilder> configurer) {
        DockerExecuteActionBuilder builder = new DockerExecuteActionBuilder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public KubernetesExecuteActionBuilder kubernetes(BuilderSupport<KubernetesExecuteActionBuilder> configurer) {
        KubernetesExecuteActionBuilder builder = new KubernetesExecuteActionBuilder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public SeleniumActionBuilder selenium(BuilderSupport<SeleniumActionBuilder> configurer) {
        SeleniumActionBuilder builder = new SeleniumActionBuilder();
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public HttpActionBuilder http(BuilderSupport<HttpActionBuilder> configurer) {
        HttpActionBuilder builder = new HttpActionBuilder();
        builder.withReferenceResolver(this.context.getReferenceResolver());
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public SoapActionBuilder soap(BuilderSupport<SoapActionBuilder> configurer) {
        SoapActionBuilder builder = new SoapActionBuilder();
        builder.withReferenceResolver(this.context.getReferenceResolver());
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public CamelRouteActionBuilder camel(BuilderSupport<CamelRouteActionBuilder> configurer) {
        CamelRouteActionBuilder builder = new CamelRouteActionBuilder();
        builder.withReferenceResolver(this.context.getReferenceResolver());
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public ZooExecuteActionBuilder zookeeper(BuilderSupport<ZooExecuteActionBuilder> configurer) {
        ZooExecuteActionBuilder builder = new ZooExecuteActionBuilder();
        builder.withReferenceResolver(this.context.getReferenceResolver());
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public Template.Builder applyTemplate(BuilderSupport<Template.Builder> configurer) {
        Template.Builder builder = (Template.Builder)new Template.Builder().withReferenceResolver(this.context.getReferenceResolver());
        configurer.configure(builder);
        return this.run(builder);
    }

    @Override
    public FinallySequence.Builder doFinally() {
        FinallySequence.Builder builder = new FinallySequence.Builder(){

            public FinallySequence.Builder actions(TestActionBuilder<?> ... actions) {
                return DefaultTestRunner.this.run((FinallySequence.Builder)super.actions(actions));
            }
        };
        return this.container(builder);
    }

    public TestContext getTestContext() {
        return this.context;
    }

    @Override
    public void setTestContext(TestContext context) {
        this.context = context;
    }

    public TestCase getTestCase() {
        this.testCase.setIncremental(true);
        return this.testCase;
    }
}

