/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.testng;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestGroupAware;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.XmlTestLoader;
import com.consol.citrus.config.CitrusSpringConfig;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.testng.PrepareTestNGMethodInterceptor;
import com.consol.citrus.testng.TestNGHelper;
import com.consol.citrus.testng.TestNGParameterHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.testng.IHookCallBack;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Listeners;
import org.testng.annotations.Test;

@ContextConfiguration(classes={CitrusSpringConfig.class})
@Listeners(value={PrepareTestNGMethodInterceptor.class})
@Deprecated
public abstract class AbstractTestNGCitrusTest
extends AbstractTestNGSpringContextTests {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Citrus citrus;

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method != null && method.getAnnotation(CitrusXmlTest.class) != null) {
            List methodTestLoaders = TestNGHelper.createTestLoadersForMethod((Method)method, this::createTestLoader);
            if (!CollectionUtils.isEmpty((Collection)methodTestLoaders)) {
                try {
                    this.run(testResult, method, (TestLoader)methodTestLoaders.get(testResult.getMethod().getCurrentInvocationCount() % methodTestLoaders.size()), testResult.getMethod().getCurrentInvocationCount());
                }
                catch (Exception e) {
                    testResult.setThrowable((Throwable)e);
                    testResult.setStatus(2);
                }
            }
            super.run((IHookCallBack)new TestNGHelper.FakeExecutionCallBack(callBack.getParameters()), testResult);
            if (testResult.getThrowable() != null) {
                if (testResult.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)testResult.getThrowable();
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else {
            super.run(callBack, testResult);
        }
    }

    protected void run(ITestResult testResult, Method method, TestLoader testLoader, int invocationCount) {
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)this.applicationContext));
        }
        TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
        TestCase testCase = testLoader.load();
        if (testCase instanceof TestGroupAware) {
            ((TestGroupAware)testCase).setGroups(testResult.getMethod().getGroups());
        }
        this.invokeTestMethod(testResult, method, testCase, ctx, invocationCount);
    }

    protected void invokeTestMethod(ITestResult testResult, Method method, TestCase testCase, TestContext context, int invocationCount) {
        try {
            ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])this.resolveParameter(testResult, method, testCase, context, invocationCount));
        }
        catch (TestCaseFailedException e) {
            throw e;
        }
        catch (AssertionError | Exception e) {
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
            testCase.finish(context);
            throw new TestCaseFailedException((Throwable)e);
        }
        this.citrus.run((TestAction)testCase, context);
    }

    protected Object[] resolveParameter(ITestResult testResult, Method method, TestCase testCase, TestContext context, int invocationCount) {
        Object[] dataProviderParams = null;
        if (method.getAnnotation(Test.class) != null && StringUtils.hasText((String)method.getAnnotation(Test.class).dataProvider())) {
            Method[] dataProvider = new Method[1];
            ReflectionUtils.doWithMethods(method.getDeclaringClass(), current -> {
                if (StringUtils.hasText((String)current.getAnnotation(DataProvider.class).name()) && current.getAnnotation(DataProvider.class).name().equals(method.getAnnotation(Test.class).dataProvider())) {
                    dataProvider[0] = current;
                } else if (current.getName().equals(method.getAnnotation(Test.class).dataProvider())) {
                    dataProvider[0] = current;
                }
            }, toFilter -> toFilter.getAnnotation(DataProvider.class) != null);
            if (dataProvider[0] == null) {
                throw new CitrusRuntimeException("Unable to find data provider: " + method.getAnnotation(Test.class).dataProvider());
            }
            Object[][] parameters = (Object[][])ReflectionUtils.invokeMethod((Method)dataProvider[0], (Object)((Object)this), (Object[])this.resolveParameter(testResult, dataProvider[0], testCase, context, -1));
            if (parameters != null) {
                dataProviderParams = parameters[invocationCount % parameters.length];
                TestNGParameterHelper.injectTestParameters((Method)method, (TestCase)testCase, (Object[])dataProviderParams);
            }
        }
        Object[] values = new Object[method.getParameterTypes().length];
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] parameterAnnotations = method.getParameterAnnotations()[i];
            Class<?> parameterType = parameterTypes[i];
            for (Annotation annotation : parameterAnnotations) {
                if (!(annotation instanceof CitrusResource)) continue;
                values[i] = this.resolveAnnotatedResource(testResult, parameterType, context);
            }
            if (parameterType.equals(ITestResult.class)) {
                values[i] = testResult;
                continue;
            }
            if (parameterType.equals(ITestContext.class)) {
                values[i] = testResult.getTestContext();
                continue;
            }
            if (values[i] != null || dataProviderParams == null || i >= dataProviderParams.length) continue;
            values[i] = dataProviderParams[i];
        }
        return values;
    }

    protected Object resolveAnnotatedResource(ITestResult testResult, Class<?> parameterType, TestContext context) {
        if (TestContext.class.isAssignableFrom(parameterType)) {
            return context;
        }
        throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + parameterType);
    }

    @BeforeSuite(alwaysRun=true)
    public void beforeSuite(ITestContext testContext) throws Exception {
        this.springTestContextPrepareTestInstance();
        Assert.notNull((Object)this.applicationContext, (String)"Missing proper application context in before suite initialization");
        this.citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)this.applicationContext));
        this.citrus.beforeSuite(testContext.getSuite().getName(), testContext.getIncludedGroups());
    }

    @AfterSuite(alwaysRun=true)
    public void afterSuite(ITestContext testContext) {
        if (this.citrus != null) {
            this.citrus.afterSuite(testContext.getSuite().getName(), testContext.getIncludedGroups());
        }
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    protected TestLoader createTestLoader(String testName, String packageName) {
        return new XmlTestLoader(((Object)((Object)this)).getClass(), testName, packageName, Optional.ofNullable(this.citrus).map(Citrus::getCitrusContext).orElseGet(() -> CitrusSpringContext.create((ApplicationContext)this.applicationContext)));
    }

    protected TestCase getTestCase() {
        return this.createTestLoader(((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).getClass().getPackage().getName()).load();
    }
}

