/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jdbc.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.jdbc.config.annotation.JdbcServerConfig;
import com.consol.citrus.jdbc.server.JdbcServer;
import com.consol.citrus.jdbc.server.JdbcServerBuilder;
import com.consol.citrus.message.MessageCorrelator;
import org.springframework.util.StringUtils;

public class JdbcServerConfigParser
extends AbstractAnnotationConfigParser<JdbcServerConfig, JdbcServer> {
    public JdbcServerConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public JdbcServer parse(JdbcServerConfig annotation) {
        JdbcServerBuilder builder = new JdbcServerBuilder();
        builder.autoStart(annotation.autoStart());
        if (StringUtils.hasText((String)annotation.host())) {
            builder.host(annotation.host());
        }
        builder.port(annotation.port());
        builder.debugLogging(annotation.debugLogging());
        if (StringUtils.hasText((String)annotation.endpointAdapter())) {
            builder.endpointAdapter((EndpointAdapter)this.getReferenceResolver().resolve(annotation.endpointAdapter(), EndpointAdapter.class));
        }
        if (StringUtils.hasText((String)annotation.databaseName())) {
            builder.databaseName(annotation.databaseName());
        }
        builder.autoConnect(annotation.autoConnect());
        builder.autoCreateStatement(annotation.autoCreateStatement());
        builder.autoTransactionHandling(annotation.autoTransactionHandling());
        builder.autoHandleQueries(annotation.autoHandleQueries());
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)this.getReferenceResolver().resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.maxConnections(annotation.maxConnections());
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (JdbcServer)builder.initialize().build();
    }
}

