/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jdbc.server;

import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.server.JdbcServerException;
import com.consol.citrus.db.server.controller.JdbcController;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.jdbc.data.DataSetCreator;
import com.consol.citrus.jdbc.message.JdbcMessage;
import com.consol.citrus.jdbc.model.Execute;
import com.consol.citrus.jdbc.model.OpenConnection;
import com.consol.citrus.jdbc.model.Operation;
import com.consol.citrus.jdbc.model.OperationResult;
import com.consol.citrus.jdbc.server.JdbcEndpointConfiguration;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;

public class JdbcEndpointAdapterController
implements JdbcController,
EndpointAdapter {
    private static Logger log = LoggerFactory.getLogger(JdbcEndpointAdapterController.class);
    private final JdbcEndpointConfiguration endpointConfiguration;
    private final EndpointAdapter delegate;
    private final DataSetCreator dataSetCreator;
    private AtomicInteger connections = new AtomicInteger(0);
    private boolean transactionState;
    protected static final String AUTO_HANDLE_QUERY_PROPERTY = "citrus.jdbc.auto.handle.query";
    protected static final String AUTO_HANDLE_QUERY_ENV = "CITRUS_JDBC_AUTO_HANDLE_QUERY";
    private Pattern autoHandleQueryPattern;

    JdbcEndpointAdapterController(JdbcEndpointConfiguration endpointConfiguration, EndpointAdapter delegate) {
        this(endpointConfiguration, delegate, new DataSetCreator());
    }

    JdbcEndpointAdapterController(JdbcEndpointConfiguration endpointConfiguration, EndpointAdapter delegate, DataSetCreator dataSetCreator) {
        this.endpointConfiguration = endpointConfiguration;
        this.delegate = delegate;
        this.dataSetCreator = dataSetCreator;
        String autoHandleQueries = System.getProperty(AUTO_HANDLE_QUERY_PROPERTY, System.getenv(AUTO_HANDLE_QUERY_ENV) != null ? System.getenv(AUTO_HANDLE_QUERY_ENV) : StringUtils.arrayToDelimitedString((Object[])endpointConfiguration.getAutoHandleQueries(), (String)";"));
        List autoQueryPatterns = Arrays.stream(autoHandleQueries.split(";")).map(String::trim).filter(validationQuery -> !StringUtils.isEmpty((Object)validationQuery)).map(validationQueryPattern -> "(?i)\\A" + validationQueryPattern + "\\Z").collect(Collectors.toList());
        this.autoHandleQueryPattern = Pattern.compile(String.join((CharSequence)"|", autoQueryPatterns));
    }

    public Message handleMessage(Message request) {
        String sqlQuery;
        if (request.getPayload() instanceof Operation) {
            StringResult result = new StringResult();
            this.endpointConfiguration.getMarshaller().marshal(request.getPayload(Operation.class), (Result)result);
            request.setPayload((Object)result.toString());
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received request on server: '%s':%n%s", this.endpointConfiguration.getServerConfiguration().getDatabaseName(), request.getPayload(String.class)));
        }
        if (request.getPayload(Operation.class) != null && this.autoHandleQueryPattern.matcher(sqlQuery = Optional.ofNullable(((Operation)request.getPayload(Operation.class)).getExecute()).map(Execute::getStatement).map(Execute.Statement::getSql).orElse("")).find()) {
            log.debug(String.format("Auto handle query '%s' with positive response", sqlQuery));
            JdbcMessage defaultResponse = JdbcMessage.success().rowsUpdated(0);
            defaultResponse.setHeader("citrus_message_type", MessageType.XML.name());
            return defaultResponse;
        }
        return Optional.ofNullable(this.delegate.handleMessage(request)).orElse((Message)JdbcMessage.success());
    }

    public void openConnection(Map<String, String> properties) throws JdbcServerException {
        if (!this.endpointConfiguration.isAutoConnect()) {
            List<OpenConnection.Property> propertyList = this.convertToPropertyList(properties);
            this.handleMessageAndCheckResponse((Message)JdbcMessage.openConnection(propertyList));
        }
        if (this.connections.get() == this.endpointConfiguration.getServerConfiguration().getMaxConnections()) {
            throw new JdbcServerException(String.format("Maximum number of connections (%s) reached", this.endpointConfiguration.getServerConfiguration().getMaxConnections()));
        }
        this.connections.incrementAndGet();
    }

    public void closeConnection() throws JdbcServerException {
        if (!this.endpointConfiguration.isAutoConnect()) {
            this.handleMessageAndCheckResponse((Message)JdbcMessage.closeConnection());
        }
        if (this.connections.decrementAndGet() < 0) {
            this.connections.set(0);
        }
    }

    public void createPreparedStatement(String stmt) throws JdbcServerException {
        if (!this.endpointConfiguration.isAutoCreateStatement()) {
            this.handleMessageAndCheckResponse((Message)JdbcMessage.createPreparedStatement(stmt));
        }
    }

    public void createStatement() throws JdbcServerException {
        if (!this.endpointConfiguration.isAutoCreateStatement()) {
            this.handleMessageAndCheckResponse((Message)JdbcMessage.createStatement());
        }
    }

    public DataSet executeQuery(String query) throws JdbcServerException {
        log.info("Received execute query request: " + query);
        Message response = this.handleMessageAndCheckResponse((Message)JdbcMessage.execute(query));
        return this.dataSetCreator.createDataSet(response, this.getMessageType(response));
    }

    public DataSet executeStatement(String stmt) throws JdbcServerException {
        log.info("Received execute statement request: " + stmt);
        Message response = this.handleMessageAndCheckResponse((Message)JdbcMessage.execute(stmt));
        return this.dataSetCreator.createDataSet(response, this.getMessageType(response));
    }

    public int executeUpdate(String updateSql) throws JdbcServerException {
        log.info("Received execute update request: " + updateSql);
        Message response = this.handleMessageAndCheckResponse((Message)JdbcMessage.execute(updateSql));
        return Optional.ofNullable(response.getHeader("citrus_jdbc_rows_updated")).map(Object::toString).map(Integer::valueOf).orElse(0);
    }

    public void closeStatement() throws JdbcServerException {
        if (!this.endpointConfiguration.isAutoCreateStatement()) {
            this.handleMessageAndCheckResponse((Message)JdbcMessage.closeStatement());
        }
    }

    public void setTransactionState(boolean transactionState) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received transaction state change: '%s':%n%s", this.endpointConfiguration.getServerConfiguration().getDatabaseName(), String.valueOf(transactionState)));
        }
        this.transactionState = transactionState;
        if (!this.endpointConfiguration.isAutoTransactionHandling() && transactionState) {
            this.handleMessageAndCheckResponse(JdbcMessage.startTransaction());
        }
    }

    public boolean getTransactionState() {
        return this.transactionState;
    }

    public void commitStatements() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received transaction commit: '%s':%n", this.endpointConfiguration.getServerConfiguration().getDatabaseName()));
        }
        if (!this.endpointConfiguration.isAutoTransactionHandling()) {
            this.handleMessageAndCheckResponse(JdbcMessage.commitTransaction());
        }
    }

    public void rollbackStatements() {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Received transaction rollback: '%s':%n", this.endpointConfiguration.getServerConfiguration().getDatabaseName()));
        }
        if (!this.endpointConfiguration.isAutoTransactionHandling()) {
            this.handleMessageAndCheckResponse(JdbcMessage.rollbackTransaction());
        }
    }

    public void createCallableStatement(String sql) {
        if (!this.endpointConfiguration.isAutoCreateStatement()) {
            this.handleMessageAndCheckResponse(JdbcMessage.createCallableStatement(sql));
        }
    }

    private MessageType getMessageType(Message response) {
        String messageTypeString = (String)response.getHeader("citrus_message_type");
        if (MessageType.knows((String)messageTypeString)) {
            return MessageType.valueOf((String)messageTypeString.toUpperCase());
        }
        return null;
    }

    private List<OpenConnection.Property> convertToPropertyList(Map<String, String> properties) {
        return properties.entrySet().stream().map(this::convertToProperty).sorted(Comparator.comparingInt(Object::hashCode)).collect(Collectors.toList());
    }

    private OpenConnection.Property convertToProperty(Map.Entry<String, String> entry) {
        OpenConnection.Property property = new OpenConnection.Property();
        property.setName(entry.getKey());
        property.setValue(entry.getValue());
        return property;
    }

    private Message handleMessageAndCheckResponse(Message request) throws JdbcServerException {
        Message response = this.handleMessage(request);
        this.checkSuccess(response);
        return response;
    }

    private void checkSuccess(Message response) throws JdbcServerException {
        OperationResult operationResult = null;
        if (response instanceof JdbcMessage || response.getPayload() instanceof OperationResult) {
            operationResult = (OperationResult)response.getPayload(OperationResult.class);
        } else if (response.getPayload() != null && StringUtils.hasText((String)((String)response.getPayload(String.class)))) {
            operationResult = (OperationResult)this.endpointConfiguration.getMarshaller().unmarshal((Source)new StringSource((String)response.getPayload(String.class)));
        }
        if (!this.success(response, operationResult)) {
            throw new JdbcServerException(this.getExceptionMessage(response, operationResult));
        }
    }

    private String getExceptionMessage(Message response, OperationResult operationResult) {
        return Optional.ofNullable(response.getHeader("citrus_jdbc_server_exception")).map(Object::toString).orElse(Optional.ofNullable(operationResult).map(OperationResult::getException).orElse(""));
    }

    private boolean success(Message response, OperationResult result) {
        return Optional.ofNullable(response.getHeader("citrus_jdbc_server_success")).map(Object::toString).map(Boolean::valueOf).orElse(Optional.ofNullable(result).map(OperationResult::isSuccess).orElse(true));
    }

    public Endpoint getEndpoint() {
        return this.delegate.getEndpoint();
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.delegate.getEndpointConfiguration();
    }

    AtomicInteger getConnections() {
        return this.connections;
    }
}

