/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jdbc.data;

import com.consol.citrus.db.driver.dataset.DataSet;
import com.consol.citrus.db.driver.json.JsonDataSetProducer;
import com.consol.citrus.db.driver.xml.XmlDataSetProducer;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.jdbc.message.JdbcMessage;
import com.consol.citrus.jdbc.model.JdbcMarshaller;
import com.consol.citrus.jdbc.model.OperationResult;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.xml.StringSource;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import javax.xml.transform.Source;
import org.springframework.util.StringUtils;

public class DataSetCreator {
    public DataSet createDataSet(Message response, MessageType messageType) {
        try {
            if (response.getPayload() instanceof DataSet) {
                return (DataSet)response.getPayload(DataSet.class);
            }
            if (this.isReadyToMarshal(response, messageType)) {
                return this.marshalResponse(response, messageType);
            }
            return new DataSet();
        }
        catch (SQLException e) {
            throw new CitrusRuntimeException("Failed to read dataSet from response message", (Throwable)e);
        }
    }

    private DataSet marshalResponse(Message response, MessageType messageType) throws SQLException {
        String dataSet = null;
        if (response instanceof JdbcMessage || response.getPayload() instanceof OperationResult) {
            dataSet = ((OperationResult)response.getPayload(OperationResult.class)).getDataSet();
        } else {
            try {
                JdbcMarshaller jdbcMarshaller = new JdbcMarshaller();
                jdbcMarshaller.setType(messageType.name());
                Object object = jdbcMarshaller.unmarshal((Source)new StringSource((String)response.getPayload(String.class)));
                if (object instanceof OperationResult && StringUtils.hasText((String)((OperationResult)object).getDataSet())) {
                    dataSet = ((OperationResult)object).getDataSet();
                }
            }
            catch (CitrusRuntimeException e) {
                dataSet = (String)response.getPayload(String.class);
            }
        }
        if (this.isJsonResponse(messageType)) {
            return new JsonDataSetProducer(Optional.ofNullable(dataSet).orElse("[]")).produce();
        }
        if (this.isXmlResponse(messageType)) {
            return new XmlDataSetProducer(Optional.ofNullable(dataSet).orElse("<dataset></dataset>")).produce();
        }
        throw new CitrusRuntimeException("Unable to create dataSet from data type " + messageType.name());
    }

    private boolean isReadyToMarshal(Message response, MessageType messageType) {
        return response.getPayload() != null && (response.getPayload() instanceof OperationResult || StringUtils.hasText((String)((String)response.getPayload(String.class)))) && this.isKnownMessageType(messageType);
    }

    private boolean isKnownMessageType(MessageType messageType) {
        return this.isXmlResponse(messageType) || this.isJsonResponse(messageType);
    }

    private boolean isXmlResponse(MessageType messageType) {
        return Objects.equals(MessageType.XML, messageType);
    }

    private boolean isJsonResponse(MessageType messageType) {
        return Objects.equals(MessageType.JSON, messageType);
    }
}

