/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jdbc.server;

import com.consol.citrus.db.server.JdbcServerConfiguration;
import com.consol.citrus.jdbc.server.JdbcServer;
import com.consol.citrus.message.MessageCorrelator;
import com.consol.citrus.server.AbstractServerBuilder;

public class JdbcServerBuilder
extends AbstractServerBuilder<JdbcServer, JdbcServerBuilder> {
    private final JdbcServer endpoint = new JdbcServer();

    protected JdbcServer getEndpoint() {
        return this.endpoint;
    }

    public JdbcServerBuilder host(String host) {
        this.endpoint.getEndpointConfiguration().getServerConfiguration().setHost(host);
        return this;
    }

    public JdbcServerBuilder port(int port) {
        this.endpoint.getEndpointConfiguration().getServerConfiguration().setPort(port);
        return this;
    }

    public JdbcServerBuilder databaseName(String name) {
        this.endpoint.getEndpointConfiguration().getServerConfiguration().setDatabaseName(name);
        return this;
    }

    public JdbcServerBuilder autoConnect(boolean autoConnect) {
        this.endpoint.getEndpointConfiguration().setAutoConnect(autoConnect);
        return this;
    }

    public JdbcServerBuilder autoCreateStatement(boolean autoCreateStatement) {
        this.endpoint.getEndpointConfiguration().setAutoCreateStatement(autoCreateStatement);
        return this;
    }

    public JdbcServerBuilder autoHandleQueries(String ... autoHandleQueries) {
        this.endpoint.getEndpointConfiguration().setAutoHandleQueries(autoHandleQueries);
        return this;
    }

    public JdbcServerBuilder correlator(MessageCorrelator correlator) {
        this.endpoint.getEndpointConfiguration().setCorrelator(correlator);
        return this;
    }

    public JdbcServerBuilder maxConnections(int maxConnections) {
        this.endpoint.getEndpointConfiguration().getServerConfiguration().setMaxConnections(maxConnections);
        return this;
    }

    public JdbcServerBuilder pollingInterval(long pollingInterval) {
        this.endpoint.getEndpointConfiguration().setPollingInterval(pollingInterval);
        return this;
    }

    public JdbcServerBuilder autoTransactionHandling(boolean autoTransactionHandling) {
        this.endpoint.getEndpointConfiguration().setAutoTransactionHandling(autoTransactionHandling);
        return this;
    }

    public JdbcServerBuilder serverConfiguration(JdbcServerConfiguration serverConfiguration) {
        this.endpoint.getEndpointConfiguration().setServerConfiguration(serverConfiguration);
        return this;
    }
}

