/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jdbc.generator;

import com.consol.citrus.jdbc.model.CloseConnection;
import com.consol.citrus.jdbc.model.CloseStatement;
import com.consol.citrus.jdbc.model.CreateCallableStatement;
import com.consol.citrus.jdbc.model.CreatePreparedStatement;
import com.consol.citrus.jdbc.model.CreateStatement;
import com.consol.citrus.jdbc.model.Execute;
import com.consol.citrus.jdbc.model.OpenConnection;
import com.consol.citrus.jdbc.model.Operation;
import com.consol.citrus.jdbc.model.TransactionCommitted;
import com.consol.citrus.jdbc.model.TransactionRollback;
import com.consol.citrus.jdbc.model.TransactionStarted;

public class JdbcOperationGenerator {
    public Operation generateOpenConnection(OpenConnection openConnection) {
        Operation operation = new Operation();
        operation.setOpenConnection(openConnection);
        return operation;
    }

    public Operation generateCloseConnection() {
        Operation operation = new Operation();
        operation.setCloseConnection(new CloseConnection());
        return operation;
    }

    public Operation generatePreparedStatement(String sql) {
        Operation operation = new Operation();
        CreatePreparedStatement createPreparedStatement = new CreatePreparedStatement();
        createPreparedStatement.setSql(sql);
        operation.setCreatePreparedStatement(createPreparedStatement);
        return operation;
    }

    public Operation generateCreateStatement() {
        Operation operation = new Operation();
        operation.setCreateStatement(new CreateStatement());
        return operation;
    }

    public Operation generateCloseStatement() {
        Operation operation = new Operation();
        operation.setCloseStatement(new CloseStatement());
        return operation;
    }

    public Operation generateExecuteStatement(String sql) {
        Operation operation = new Operation();
        Execute.Statement statement = new Execute.Statement();
        statement.setSql(sql);
        Execute execute = new Execute();
        execute.setStatement(statement);
        operation.setExecute(execute);
        return operation;
    }

    public Operation generateTransactionStarted() {
        Operation operation = new Operation();
        operation.setTransactionStarted(new TransactionStarted());
        return operation;
    }

    public Operation generateTransactionCommitted() {
        Operation operation = new Operation();
        operation.setTransactionCommitted(new TransactionCommitted());
        return operation;
    }

    public Operation generateTransactionRollback() {
        Operation operation = new Operation();
        operation.setTransactionRollback(new TransactionRollback());
        return operation;
    }

    public Operation generateCreateCallableStatement(String sql) {
        Operation operation = new Operation();
        CreateCallableStatement createCallableStatement = new CreateCallableStatement();
        createCallableStatement.setSql(sql);
        operation.setCreateCallableStatement(createCallableStatement);
        return operation;
    }
}

