/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jdbc.message;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.jdbc.generator.JdbcOperationGenerator;
import com.consol.citrus.jdbc.model.JdbcMarshaller;
import com.consol.citrus.jdbc.model.OpenConnection;
import com.consol.citrus.jdbc.model.Operation;
import com.consol.citrus.jdbc.model.OperationResult;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.xml.StringResult;
import com.consol.citrus.xml.StringSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.springframework.core.io.Resource;

public class JdbcMessage
extends DefaultMessage {
    private OperationResult operationResult;
    private Operation operation;
    private JdbcMarshaller marshaller = new JdbcMarshaller();
    private static JdbcOperationGenerator operationGenerator = new JdbcOperationGenerator();

    private JdbcMessage() {
    }

    private JdbcMessage(Operation operation) {
        super((Object)operation);
        this.operation = operation;
    }

    private JdbcMessage(OperationResult operationResult) {
        super((Object)operationResult);
        this.operationResult = operationResult;
    }

    public static JdbcMessage openConnection(OpenConnection.Property ... properties) {
        OpenConnection openConnection = new OpenConnection();
        if (properties.length > 0) {
            openConnection.getProperties().addAll(Arrays.asList(properties));
        }
        return new JdbcMessage(operationGenerator.generateOpenConnection(openConnection));
    }

    public static JdbcMessage openConnection(List<OpenConnection.Property> properties) {
        OpenConnection openConnection = new OpenConnection();
        openConnection.getProperties().addAll(properties);
        return new JdbcMessage(operationGenerator.generateOpenConnection(openConnection));
    }

    public static JdbcMessage closeConnection() {
        return new JdbcMessage(operationGenerator.generateCloseConnection());
    }

    public static JdbcMessage createPreparedStatement(String sql) {
        return new JdbcMessage(operationGenerator.generatePreparedStatement(sql));
    }

    public static JdbcMessage createStatement() {
        return new JdbcMessage(operationGenerator.generateCreateStatement());
    }

    public static JdbcMessage closeStatement() {
        return new JdbcMessage(operationGenerator.generateCloseStatement());
    }

    public static JdbcMessage execute(String sql) {
        return new JdbcMessage(operationGenerator.generateExecuteStatement(sql));
    }

    public static JdbcMessage success() {
        return JdbcMessage.result(true);
    }

    public static JdbcMessage error() {
        return JdbcMessage.result(false);
    }

    private static JdbcMessage result(boolean success) {
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(success);
        JdbcMessage message = new JdbcMessage(operationResult);
        message.setHeader("citrus_jdbc_server_success", success);
        return message;
    }

    public static JdbcMessage result(OperationResult operationResult) {
        JdbcMessage message = new JdbcMessage(operationResult);
        message.setHeader("citrus_jdbc_server_success", operationResult.isSuccess());
        if (!operationResult.isSuccess()) {
            message.exception(operationResult.getException());
        }
        return message;
    }

    public JdbcMessage exception(String message) {
        if (this.operationResult == null) {
            throw new CitrusRuntimeException("Invalid access to operation result exception for JDBC message");
        }
        if (this.operationResult.isSuccess()) {
            throw new CitrusRuntimeException("Unable to set operation result exception on 'success' JDBC result");
        }
        this.setHeader("citrus_jdbc_server_exception", message);
        return this;
    }

    public JdbcMessage rowsUpdated(int number) {
        if (this.operationResult == null) {
            throw new CitrusRuntimeException("Invalid access to operation result exception for JDBC message");
        }
        this.operationResult.setAffectedRows(number);
        this.setHeader("citrus_jdbc_rows_updated", number);
        return this;
    }

    public JdbcMessage dataSet(String dataSet) {
        if (this.operationResult == null) {
            throw new CitrusRuntimeException("Invalid access to operation result exception for JDBC message");
        }
        this.operationResult.setDataSet(dataSet);
        return this;
    }

    public JdbcMessage dataSet(Resource dataSet) {
        try {
            this.dataSet(FileUtils.readToString((Resource)dataSet));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read data set file", (Throwable)e);
        }
        return this;
    }

    public static Message startTransaction() {
        return new JdbcMessage(operationGenerator.generateTransactionStarted());
    }

    public static Message commitTransaction() {
        return new JdbcMessage(operationGenerator.generateTransactionCommitted());
    }

    public static Message rollbackTransaction() {
        return new JdbcMessage(operationGenerator.generateTransactionRollback());
    }

    public static Message createCallableStatement(String sql) {
        return new JdbcMessage(operationGenerator.generateCreateCallableStatement(sql));
    }

    public <T> T getPayload(Class<T> type) {
        if (Operation.class.equals(type)) {
            return (T)this.getOperation();
        }
        if (OperationResult.class.equals(type)) {
            return (T)this.getOperationResult();
        }
        if (String.class.equals(type)) {
            return (T)this.getPayload();
        }
        return (T)super.getPayload(type);
    }

    public Object getPayload() {
        StringResult payloadResult = new StringResult();
        if (this.operation != null) {
            this.marshaller.marshal(this.operation, (Result)payloadResult);
            return payloadResult.toString();
        }
        if (this.operationResult != null) {
            this.marshaller.marshal(this.operationResult, (Result)payloadResult);
            return payloadResult.toString();
        }
        return super.getPayload();
    }

    private OperationResult getOperationResult() {
        if (this.operationResult == null) {
            this.operationResult = (OperationResult)this.marshaller.unmarshal((Source)new StringSource(this.getPayload(String.class)));
        }
        return this.operationResult;
    }

    private Operation getOperation() {
        if (this.operation == null) {
            this.operation = (Operation)this.marshaller.unmarshal((Source)new StringSource(this.getPayload(String.class)));
        }
        return this.operation;
    }
}

