/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jdbc.model;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.jdbc.model.Operation;
import com.consol.citrus.jdbc.model.OperationResult;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.xml.Jaxb2Marshaller;
import com.consol.citrus.xml.Marshaller;
import com.consol.citrus.xml.StringResult;
import com.consol.citrus.xml.Unmarshaller;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class JdbcMarshaller
implements Marshaller,
Unmarshaller {
    private static final Logger log = LoggerFactory.getLogger(JdbcMarshaller.class);
    private static final String JDBC_MARSHALLER_TYPE_PROPERTY = "citrus.jdbc.marshaller.type";
    private String type;
    private final ObjectMapper mapper;
    private final Jaxb2Marshaller marshaller;
    private final Class<?>[] classesToBeBound = new Class[]{Operation.class, OperationResult.class};

    public JdbcMarshaller() {
        this.mapper = new ObjectMapper();
        this.marshaller = new Jaxb2Marshaller((Resource)new ClassPathResource("com/consol/citrus/schema/citrus-jdbc-message.xsd"), (Class[])this.classesToBeBound);
        this.type = System.getProperty(JDBC_MARSHALLER_TYPE_PROPERTY, MessageType.JSON.name());
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public Object unmarshal(Source source) {
        if (this.type.equalsIgnoreCase(MessageType.XML.name())) {
            try {
                return this.marshaller.unmarshal(source);
            }
            catch (JAXBException e) {
                if (source instanceof StreamSource) {
                    for (Class<?> type : this.classesToBeBound) {
                        try {
                            return this.mapper.readValue(((StreamSource)source).getReader(), type);
                        }
                        catch (JsonParseException | JsonMappingException e2) {
                        }
                        catch (IOException io) {
                            log.warn("Failed to read jdbc JSON object from source: " + io.getMessage());
                            break;
                        }
                    }
                }
                throw new CitrusRuntimeException("Failed to read jdbc XML object from source", (Throwable)e);
            }
        }
        if (this.type.equalsIgnoreCase(MessageType.JSON.name())) {
            for (Class<?> type : this.classesToBeBound) {
                try {
                    return this.mapper.readValue(((StreamSource)source).getReader(), type);
                }
                catch (JsonParseException | JsonMappingException e2) {
                }
                catch (IOException io) {
                    throw new CitrusRuntimeException("Failed to read jdbc JSON object from source", (Throwable)io);
                }
            }
            try {
                return this.marshaller.unmarshal(source);
            }
            catch (JAXBException me) {
                log.warn("Failed to read jdbc XML object from source: " + me.getMessage());
                throw new CitrusRuntimeException("Failed to read jdbc JSON object from source" + source);
            }
        }
        throw new CitrusRuntimeException("Unsupported jdbc marshaller type: " + this.type);
    }

    public void marshal(Object graph, Result result) {
        if (this.type.equalsIgnoreCase(MessageType.JSON.name())) {
            if (result instanceof StringResult) {
                StringWriter writer = new StringWriter();
                ((StringResult)result).setWriter((Writer)writer);
                try {
                    this.mapper.writer().writeValue((Writer)writer, graph);
                }
                catch (IOException e) {
                    throw new CitrusRuntimeException("Failed to write jdbc JSON object graph to result", (Throwable)e);
                }
            }
        } else if (this.type.equalsIgnoreCase(MessageType.XML.name())) {
            try {
                this.marshaller.marshal(graph, result);
            }
            catch (JAXBException e) {
                throw new CitrusRuntimeException("Failed to write jdbc XML object to result", (Throwable)e);
            }
        } else {
            throw new CitrusRuntimeException("Unsupported jdbc marshaller type: " + this.type);
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

