/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.actions;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.DynamicDestinationResolver;

public class PurgeJmsQueuesAction
extends AbstractTestAction {
    private List<String> queueNames = new ArrayList<String>();
    private List<Queue> queues = new ArrayList<Queue>();
    private ConnectionFactory connectionFactory;
    private long receiveTimeout = 100L;
    private long sleepTime = 350L;
    private static Logger log = LoggerFactory.getLogger(PurgeJmsQueuesAction.class);

    public PurgeJmsQueuesAction() {
        this.setName("purge-queue");
    }

    public void doExecute(TestContext context) {
        log.debug("Purging JMS queues...");
        Connection connection = null;
        Session session = null;
        try {
            connection = this.createConnection();
            session = this.createSession(connection);
            connection.start();
            for (Queue queue : this.queues) {
                this.purgeQueue(queue, session);
            }
            for (String queueName : this.queueNames) {
                this.purgeQueue(queueName, session);
            }
        }
        catch (JMSException e) {
            try {
                log.error("Error while establishing jms connection", (Throwable)e);
                throw new CitrusRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                JmsUtils.closeSession(session);
                JmsUtils.closeConnection((Connection)connection, (boolean)true);
                throw throwable;
            }
        }
        JmsUtils.closeSession((Session)session);
        JmsUtils.closeConnection((Connection)connection, (boolean)true);
        log.info("Purged JMS queues");
    }

    private void purgeQueue(String queueName, Session session) throws JMSException {
        this.purgeDestination(this.getDestination(session, queueName), session, queueName);
    }

    private void purgeQueue(Queue queue, Session session) throws JMSException {
        this.purgeDestination((Destination)queue, session, queue.getQueueName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeDestination(Destination destination, Session session, String destinationName) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug("Try to purge destination " + destinationName);
        }
        int messagesPurged = 0;
        MessageConsumer messageConsumer = session.createConsumer(destination);
        try {
            Message message;
            do {
                Message message2 = message = this.receiveTimeout >= 0L ? messageConsumer.receive(this.receiveTimeout) : messageConsumer.receive();
                if (message == null) continue;
                log.debug("Removed message from destination " + destinationName);
                ++messagesPurged;
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted during wait", (Throwable)e);
                }
            } while (message != null);
            if (log.isDebugEnabled()) {
                log.debug("Purged " + messagesPurged + " messages from destination");
            }
        }
        finally {
            JmsUtils.closeMessageConsumer((MessageConsumer)messageConsumer);
        }
    }

    private Destination getDestination(Session session, String queueName) throws JMSException {
        return new DynamicDestinationResolver().resolveDestinationName(session, queueName, false);
    }

    protected Connection createConnection() throws JMSException {
        if (this.connectionFactory instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)this.connectionFactory).createQueueConnection();
        }
        return this.connectionFactory.createConnection();
    }

    protected Session createSession(Connection connection) throws JMSException {
        if (connection instanceof QueueConnection) {
            return ((QueueConnection)connection).createQueueSession(false, 1);
        }
        return connection.createSession(false, 1);
    }

    public void setQueueNames(List<String> queueNames) {
        this.queueNames = queueNames;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public List<String> getQueueNames() {
        return this.queueNames;
    }

    public void setQueues(List<Queue> queues) {
        this.queues = queues;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public List<Queue> getQueues() {
        return this.queues;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }
}

