/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.jms.config.annotation.JmsEndpointConfig;
import com.consol.citrus.jms.endpoint.JmsEndpoint;
import com.consol.citrus.jms.endpoint.JmsEndpointBuilder;
import com.consol.citrus.jms.message.JmsMessageConverter;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.StringUtils;

public class JmsEndpointConfigParser
extends AbstractAnnotationConfigParser<JmsEndpointConfig, JmsEndpoint> {
    public JmsEndpointConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public JmsEndpoint parse(JmsEndpointConfig annotation) {
        JmsEndpointBuilder builder = new JmsEndpointBuilder();
        String jmsTemplate = annotation.jmsTemplate();
        String destination = annotation.destination();
        String destinationName = annotation.destinationName();
        if (StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName)) {
            String connectionFactory = "connectionFactory";
            if (StringUtils.hasText((String)annotation.connectionFactory())) {
                connectionFactory = annotation.connectionFactory();
            }
            if (!StringUtils.hasText((String)connectionFactory)) {
                throw new CitrusRuntimeException("Required connection-factory is missing for jms configuration");
            }
            builder.connectionFactory((ConnectionFactory)this.getReferenceResolver().resolve(connectionFactory, ConnectionFactory.class));
            if (StringUtils.hasText((String)destination)) {
                builder.destination((Destination)this.getReferenceResolver().resolve(annotation.destination(), Destination.class));
            } else {
                builder.destination(annotation.destinationName());
            }
        } else if (StringUtils.hasText((String)jmsTemplate)) {
            if (StringUtils.hasText((String)annotation.connectionFactory()) || StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName)) {
                throw new CitrusRuntimeException("When providing a jms-template, none of connection-factory, destination, or destination-name should be provided");
            }
            builder.jmsTemplate((JmsTemplate)this.getReferenceResolver().resolve(jmsTemplate, JmsTemplate.class));
        } else {
            throw new CitrusRuntimeException("Either a jms-template reference or one of destination or destination-name must be provided");
        }
        builder.pubSubDomain(annotation.pubSubDomain());
        builder.useObjectMessages(annotation.useObjectMessages());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((JmsMessageConverter)this.getReferenceResolver().resolve(annotation.messageConverter(), JmsMessageConverter.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (JmsEndpoint)builder.initialize().build();
    }
}

