/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.jms.endpoint.JmsEndpointConfiguration;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.AbstractSelectiveMessageConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JmsConsumer
extends AbstractSelectiveMessageConsumer {
    private static Logger log = LoggerFactory.getLogger(JmsConsumer.class);
    private final JmsEndpointConfiguration endpointConfiguration;

    public JmsConsumer(String name, JmsEndpointConfiguration endpointConfiguration) {
        super(name, (EndpointConfiguration)endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
    }

    public Message receive(String selector, TestContext context, long timeout) {
        String destinationName = StringUtils.hasText((String)selector) ? this.endpointConfiguration.getDefaultDestinationName() + "(" + selector + ")'" : this.endpointConfiguration.getDefaultDestinationName();
        log.debug("Receiving JMS message on destination: '" + destinationName + "'");
        this.endpointConfiguration.getJmsTemplate().setReceiveTimeout(timeout);
        javax.jms.Message receivedJmsMessage = StringUtils.hasText((String)selector) ? this.endpointConfiguration.getJmsTemplate().receiveSelected(selector) : this.endpointConfiguration.getJmsTemplate().receive();
        if (receivedJmsMessage == null) {
            throw new ActionTimeoutException("Action timed out while receiving JMS message on '" + destinationName + "'");
        }
        Message receivedMessage = this.endpointConfiguration.getMessageConverter().convertInbound(receivedJmsMessage, this.endpointConfiguration, context);
        log.info("Received JMS message on destination: '" + destinationName + "'");
        context.onInboundMessage(receivedMessage);
        return receivedMessage;
    }
}

