/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.jms.endpoint.JmsEndpointConfiguration;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.Producer;
import javax.jms.JMSException;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.MessageCreator;
import org.springframework.util.Assert;

public class JmsProducer
implements Producer {
    private static Logger log = LoggerFactory.getLogger(JmsProducer.class);
    private final String name;
    private final JmsEndpointConfiguration endpointConfiguration;

    public JmsProducer(String name, JmsEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public void send(final Message message, final TestContext context) {
        Assert.notNull((Object)message, (String)"Message is empty - unable to send empty message");
        String defaultDestinationName = this.endpointConfiguration.getDefaultDestinationName();
        if (log.isDebugEnabled()) {
            log.debug("Sending JMS message to destination: '" + defaultDestinationName + "'");
        }
        this.endpointConfiguration.getJmsTemplate().send(new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message jmsMessage = JmsProducer.this.endpointConfiguration.getMessageConverter().createJmsMessage(message, session, JmsProducer.this.endpointConfiguration, context);
                JmsProducer.this.endpointConfiguration.getMessageConverter().convertOutbound(jmsMessage, message, JmsProducer.this.endpointConfiguration, context);
                return jmsMessage;
            }
        });
        context.onOutboundMessage(message);
        log.info("Message was sent to JMS destination: '" + defaultDestinationName + "'");
    }

    public String getName() {
        return this.name;
    }
}

