/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.PollableEndpointConfiguration;
import com.consol.citrus.jms.endpoint.JmsConsumer;
import com.consol.citrus.jms.endpoint.JmsSyncEndpointConfiguration;
import com.consol.citrus.jms.message.JmsMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.correlation.CorrelationManager;
import com.consol.citrus.message.correlation.PollingCorrelationManager;
import com.consol.citrus.messaging.ReplyProducer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.MessageCreator;
import org.springframework.util.Assert;

public class JmsSyncConsumer
extends JmsConsumer
implements ReplyProducer {
    private CorrelationManager<Destination> correlationManager;
    private final JmsSyncEndpointConfiguration endpointConfiguration;
    private static Logger log = LoggerFactory.getLogger(JmsSyncConsumer.class);

    public JmsSyncConsumer(String name, JmsSyncEndpointConfiguration endpointConfiguration) {
        super(name, endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
        this.correlationManager = new PollingCorrelationManager((PollableEndpointConfiguration)endpointConfiguration, "Reply jms destination not set up yet");
    }

    @Override
    public Message receive(String selector, TestContext context, long timeout) {
        Message receivedMessage = super.receive(selector, context, timeout);
        JmsMessage jmsMessage = receivedMessage instanceof JmsMessage ? (JmsMessage)receivedMessage : new JmsMessage(receivedMessage);
        this.saveReplyDestination(jmsMessage, context);
        return jmsMessage;
    }

    public void send(final Message message, final TestContext context) {
        Assert.notNull((Object)message, (String)"Message is empty - unable to send empty message");
        String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
        String correlationKey = this.correlationManager.getCorrelationKey(correlationKeyName, context);
        Destination replyDestination = (Destination)this.correlationManager.find(correlationKey, this.endpointConfiguration.getTimeout());
        Assert.notNull((Object)replyDestination, (String)("Failed to find JMS reply destination for message correlation key: '" + correlationKey + "'"));
        if (log.isDebugEnabled()) {
            log.debug("Sending JMS message to destination: '" + this.getDestinationName(replyDestination) + "'");
        }
        this.endpointConfiguration.getJmsTemplate().send(replyDestination, new MessageCreator(){

            public javax.jms.Message createMessage(Session session) throws JMSException {
                javax.jms.Message jmsMessage = JmsSyncConsumer.this.endpointConfiguration.getMessageConverter().createJmsMessage(message, session, JmsSyncConsumer.this.endpointConfiguration, context);
                JmsSyncConsumer.this.endpointConfiguration.getMessageConverter().convertOutbound(jmsMessage, message, JmsSyncConsumer.this.endpointConfiguration, context);
                return jmsMessage;
            }
        });
        context.onOutboundMessage(message);
        log.info("Message was sent to JMS destination: '" + this.getDestinationName(replyDestination) + "'");
    }

    public void saveReplyDestination(JmsMessage jmsMessage, TestContext context) {
        if (jmsMessage.getReplyTo() != null) {
            String correlationKeyName = this.endpointConfiguration.getCorrelator().getCorrelationKeyName(this.getName());
            String correlationKey = this.endpointConfiguration.getCorrelator().getCorrelationKey((Message)jmsMessage);
            this.correlationManager.saveCorrelationKey(correlationKeyName, correlationKey, context);
            this.correlationManager.store(correlationKey, (Object)jmsMessage.getReplyTo());
        } else {
            log.warn("Unable to retrieve reply to destination for message \n" + (Object)((Object)jmsMessage) + "\n - no reply to destination found in message headers!");
        }
    }

    private String getDestinationName(Destination destination) {
        try {
            if (destination != null) {
                if (destination instanceof Queue) {
                    return ((Queue)destination).getQueueName();
                }
                if (destination instanceof Topic) {
                    return ((Topic)destination).getTopicName();
                }
                return destination.toString();
            }
            return null;
        }
        catch (JMSException e) {
            log.error("Error while getting destination name", (Throwable)e);
            return "";
        }
    }

    public CorrelationManager<Destination> getCorrelationManager() {
        return this.correlationManager;
    }

    public void setCorrelationManager(CorrelationManager<Destination> correlationManager) {
        this.correlationManager = correlationManager;
    }
}

