/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.message;

import com.consol.citrus.Citrus;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.jms.endpoint.JmsEndpointConfiguration;
import com.consol.citrus.jms.message.JmsMessageConverter;
import com.consol.citrus.message.Message;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.jms.Session;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapMessageFactory;
import org.springframework.xml.transform.StringResult;
import org.springframework.xml.transform.StringSource;

public class SoapJmsMessageConverter
extends JmsMessageConverter {
    private static Logger log = LoggerFactory.getLogger(SoapJmsMessageConverter.class);
    @Autowired
    private SoapMessageFactory soapMessageFactory;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final String SOAP_ACTION_HEADER = "citrus_soap_action";
    private String jmsSoapActionHeader = "SOAPJMS_soapAction";

    @Override
    public Message convertInbound(javax.jms.Message jmsMessage, JmsEndpointConfiguration endpointConfiguration, TestContext context) {
        try {
            Message message = super.convertInbound(jmsMessage, endpointConfiguration, context);
            ByteArrayInputStream in = new ByteArrayInputStream(((String)message.getPayload(String.class)).getBytes(Citrus.CITRUS_FILE_ENCODING));
            SoapMessage soapMessage = this.soapMessageFactory.createWebServiceMessage((InputStream)in);
            StringResult payload = new StringResult();
            this.transformerFactory.newTransformer().transform(soapMessage.getPayloadSource(), (Result)payload);
            if (message.getHeader(this.jmsSoapActionHeader) != null) {
                message.setHeader(SOAP_ACTION_HEADER, message.getHeader(this.jmsSoapActionHeader));
            }
            message.setPayload((Object)payload.toString());
            return message;
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException("Failed to transform SOAP message body to payload", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CitrusRuntimeException("Found unsupported default encoding", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read SOAP message payload", (Throwable)e);
        }
    }

    @Override
    public javax.jms.Message createJmsMessage(Message message, Session session, JmsEndpointConfiguration endpointConfiguration, TestContext context) {
        String payload = (String)message.getPayload(String.class);
        log.debug("Creating SOAP message from payload: " + payload);
        try {
            SoapMessage soapMessage = this.soapMessageFactory.createWebServiceMessage();
            this.transformerFactory.newTransformer().transform((Source)new StringSource(payload), soapMessage.getPayloadResult());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)bos);
            message.setPayload((Object)new String(bos.toByteArray()));
            if (message.getHeader(SOAP_ACTION_HEADER) != null) {
                message.setHeader(this.jmsSoapActionHeader, message.getHeader(SOAP_ACTION_HEADER));
                message.removeHeader(SOAP_ACTION_HEADER);
            }
            return super.createJmsMessage(message, session, endpointConfiguration, context);
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException("Failed to transform payload to SOAP body", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write SOAP message content", (Throwable)e);
        }
    }

    public void setJmsSoapActionHeader(String jmsSoapActionHeader) {
        this.jmsSoapActionHeader = jmsSoapActionHeader;
    }

    public String getJmsSoapActionHeader() {
        return this.jmsSoapActionHeader;
    }
}

