/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpointComponent;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.jms.endpoint.JmsEndpoint;
import com.consol.citrus.jms.endpoint.JmsSyncEndpoint;
import java.util.Map;
import javax.jms.ConnectionFactory;

public class JmsEndpointComponent
extends AbstractEndpointComponent {
    protected Endpoint createEndpoint(String resourcePath, Map<String, String> parameters, TestContext context) {
        JmsEndpoint endpoint = resourcePath.startsWith("sync:") ? new JmsSyncEndpoint() : new JmsEndpoint();
        if (resourcePath.contains("topic:")) {
            endpoint.getEndpointConfiguration().setPubSubDomain(true);
        }
        if (resourcePath.indexOf(58) > 0) {
            endpoint.getEndpointConfiguration().setDestinationName(resourcePath.substring(resourcePath.lastIndexOf(58) + 1));
        } else {
            endpoint.getEndpointConfiguration().setDestinationName(resourcePath);
        }
        if (context.getApplicationContext() != null && context.getApplicationContext().containsBean("connectionFactory")) {
            endpoint.getEndpointConfiguration().setConnectionFactory((ConnectionFactory)context.getApplicationContext().getBean("connectionFactory", ConnectionFactory.class));
        }
        this.enrichEndpointConfiguration((EndpointConfiguration)endpoint.getEndpointConfiguration(), parameters, context);
        return endpoint;
    }
}

