/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.endpoint.direct.DirectEndpoint;
import com.consol.citrus.endpoint.direct.DirectEndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.jms.endpoint.JmsConsumer;
import com.consol.citrus.jms.endpoint.JmsEndpointConfiguration;
import com.consol.citrus.message.DefaultMessageQueue;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageQueue;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JmsTopicSubscriber
extends JmsConsumer
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(JmsConsumer.class);
    private boolean running = true;
    private final TestContextFactory testContextFactory;
    private DirectEndpoint messageQueue;
    private Executor subscription = Executors.newSingleThreadExecutor();
    private CompletableFuture<Boolean> stopped = new CompletableFuture();
    private CompletableFuture<Boolean> started = new CompletableFuture();

    public JmsTopicSubscriber(String name, JmsEndpointConfiguration endpointConfiguration, TestContextFactory testContextFactory) {
        super(name, endpointConfiguration);
        this.testContextFactory = testContextFactory;
        DirectEndpointConfiguration directEndpointConfiguration = new DirectEndpointConfiguration();
        DefaultMessageQueue inboundQueue = new DefaultMessageQueue();
        directEndpointConfiguration.setQueue((MessageQueue)inboundQueue);
        this.messageQueue = new DirectEndpoint(directEndpointConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ConnectionFactory connectionFactory = Optional.ofNullable(this.endpointConfiguration.getConnectionFactory()).orElse(this.endpointConfiguration.getJmsTemplate().getConnectionFactory());
        TopicConnection connection = null;
        try {
            TopicSubscriber subscriber;
            Topic topic;
            if (connectionFactory == null || !(connectionFactory instanceof TopicConnectionFactory)) {
                throw new CitrusRuntimeException("Failed to create JMS topic subscriber for unsupported connection factory type: " + Optional.ofNullable(connectionFactory).map(Object::getClass).map(Class::getName).orElse("connection factory not set"));
            }
            connection = ((TopicConnectionFactory)connectionFactory).createTopicConnection();
            TopicSession session = connection.createTopicSession(false, 1);
            if (this.endpointConfiguration.getDestination() != null && this.endpointConfiguration.getDestination() instanceof Topic) {
                topic = (Topic)this.endpointConfiguration.getDestination();
            } else if (StringUtils.hasText((String)this.endpointConfiguration.getDestinationName())) {
                topic = session.createTopic(this.endpointConfiguration.getDestinationName());
            } else if (this.endpointConfiguration.getJmsTemplate().getDefaultDestination() != null && this.endpointConfiguration.getJmsTemplate().getDefaultDestination() instanceof Topic) {
                topic = (Topic)this.endpointConfiguration.getJmsTemplate().getDefaultDestination();
            } else if (StringUtils.hasText((String)this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName())) {
                topic = session.createTopic(this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName());
            } else {
                throw new CitrusRuntimeException("Unable to receive message - JMS destination not set");
            }
            if (this.endpointConfiguration.isDurableSubscription()) {
                log.debug(String.format("Create JMS topic durable subscription '%s'", Optional.ofNullable(this.endpointConfiguration.getDurableSubscriberName()).orElse(this.getName())));
                subscriber = session.createDurableSubscriber(topic, Optional.ofNullable(this.endpointConfiguration.getDurableSubscriberName()).orElse(this.getName()));
            } else {
                log.debug("Create JMS topic subscription");
                subscriber = session.createSubscriber(topic);
            }
            connection.start();
            this.started.complete(true);
            while (this.running) {
                javax.jms.Message event = subscriber.receive();
                if (event != null) {
                    TestContext context = this.testContextFactory.getObject();
                    Message message = this.endpointConfiguration.getMessageConverter().convertInbound(event, this.endpointConfiguration, context);
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Received topic event '%s'", message.getId()));
                    }
                    this.messageQueue.createProducer().send(message, context);
                    continue;
                }
                log.warn("Topic subscriber received null message - continue after " + this.endpointConfiguration.getPollingInterval() + " milliseconds");
                try {
                    Thread.sleep(this.endpointConfiguration.getPollingInterval());
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting after null message", (Throwable)e);
                }
            }
        }
        catch (RuntimeException e) {
            this.started.completeExceptionally(e);
            throw e;
        }
        catch (JMSException e) {
            this.started.completeExceptionally(e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (JMSException e) {
                    log.warn("Failed to close JMS topic connection", (Throwable)e);
                }
            }
            this.stopped.complete(true);
        }
    }

    public void start() {
        this.subscription.execute(this);
        try {
            if (this.started.get().booleanValue()) {
                log.info("Started JMS topic subscription");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Failed to wait for topic subscriber to start subscription", (Throwable)e);
        }
    }

    public void stop() {
        this.running = false;
        try {
            this.stopped.get(this.endpointConfiguration.getTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Failed to wait for topic subscriber to stop gracefully", (Throwable)e);
        }
        catch (TimeoutException e) {
            log.warn("Timeout while waiting for topic subscriber to stop gracefully", (Throwable)e);
        }
    }

    public Message receive(TestContext context, long timeout) {
        return this.messageQueue.createConsumer().receive(context, timeout);
    }

    @Override
    public Message receive(String selector, TestContext context, long timeout) {
        return this.messageQueue.createConsumer().receive(selector, context, timeout);
    }

    public boolean isRunning() {
        return this.running;
    }
}

