/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.jms.config.annotation.JmsEndpointConfig;
import com.consol.citrus.jms.endpoint.JmsEndpoint;
import com.consol.citrus.jms.endpoint.JmsEndpointBuilder;
import com.consol.citrus.jms.message.JmsMessageConverter;
import com.consol.citrus.spi.ReferenceResolver;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.StringUtils;

public class JmsEndpointConfigParser
implements AnnotationConfigParser<JmsEndpointConfig, JmsEndpoint> {
    public JmsEndpoint parse(JmsEndpointConfig annotation, ReferenceResolver referenceResolver) {
        JmsEndpointBuilder builder = new JmsEndpointBuilder();
        String jmsTemplate = annotation.jmsTemplate();
        String destination = annotation.destination();
        String destinationName = annotation.destinationName();
        if (StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName)) {
            String connectionFactory = "connectionFactory";
            if (StringUtils.hasText((String)annotation.connectionFactory())) {
                connectionFactory = annotation.connectionFactory();
            }
            if (!StringUtils.hasText((String)connectionFactory)) {
                throw new CitrusRuntimeException("Required connection-factory is missing for jms configuration");
            }
            builder.connectionFactory((ConnectionFactory)referenceResolver.resolve(connectionFactory, ConnectionFactory.class));
            if (StringUtils.hasText((String)destination)) {
                builder.destination((Destination)referenceResolver.resolve(annotation.destination(), Destination.class));
            } else {
                builder.destination(annotation.destinationName());
            }
        } else if (StringUtils.hasText((String)jmsTemplate)) {
            if (StringUtils.hasText((String)annotation.connectionFactory()) || StringUtils.hasText((String)destination) || StringUtils.hasText((String)destinationName)) {
                throw new CitrusRuntimeException("When providing a jms-template, none of connection-factory, destination, or destination-name should be provided");
            }
            builder.jmsTemplate((JmsTemplate)referenceResolver.resolve(jmsTemplate, JmsTemplate.class));
        } else {
            throw new CitrusRuntimeException("Either a jms-template reference or one of destination or destination-name must be provided");
        }
        if (annotation.autoStart() && !annotation.pubSubDomain()) {
            throw new CitrusRuntimeException("When providing auto start enabled,  pubSubDomain should also be enabled");
        }
        if (annotation.durableSubscription() && !annotation.pubSubDomain()) {
            throw new CitrusRuntimeException("When providing durable subscription enabled,  pubSubDomain should also be enabled");
        }
        builder.pubSubDomain(annotation.pubSubDomain());
        builder.autoStart(annotation.autoStart());
        builder.durableSubscription(annotation.durableSubscription());
        if (StringUtils.hasText((String)annotation.durableSubscriberName())) {
            builder.durableSubscriberName(annotation.durableSubscriberName());
        }
        builder.useObjectMessages(annotation.useObjectMessages());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((JmsMessageConverter)referenceResolver.resolve(annotation.messageConverter(), JmsMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.destinationResolver())) {
            builder.destinationResolver((DestinationResolver)referenceResolver.resolve(annotation.destinationResolver(), DestinationResolver.class));
        }
        if (StringUtils.hasText((String)annotation.destinationNameResolver())) {
            builder.destinationNameResolver((EndpointUriResolver)referenceResolver.resolve(annotation.destinationNameResolver(), EndpointUriResolver.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (JmsEndpoint)builder.initialize().build();
    }
}

