/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.common.InitializingPhase;
import com.consol.citrus.common.ShutdownPhase;
import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.context.TestContextFactoryBean;
import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.jms.endpoint.JmsConsumer;
import com.consol.citrus.jms.endpoint.JmsEndpointConfiguration;
import com.consol.citrus.jms.endpoint.JmsProducer;
import com.consol.citrus.jms.endpoint.JmsTopicSubscriber;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.messaging.SelectiveConsumer;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import org.springframework.util.Assert;

public class JmsEndpoint
extends AbstractEndpoint
implements InitializingPhase,
ShutdownPhase,
ReferenceResolverAware {
    private JmsProducer jmsProducer;
    private JmsConsumer jmsConsumer;
    private ReferenceResolver referenceResolver;

    public JmsEndpoint() {
        super((EndpointConfiguration)new JmsEndpointConfiguration());
    }

    public JmsEndpoint(JmsEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
    }

    public SelectiveConsumer createConsumer() {
        if (this.jmsConsumer == null) {
            if (this.getEndpointConfiguration().isAutoStart()) {
                TestContextFactory testContextFactory = this.getTestContextFactory();
                JmsTopicSubscriber jmsTopicSubscriber = new JmsTopicSubscriber(this.getSubscriberName(), this.getEndpointConfiguration(), testContextFactory);
                this.jmsConsumer = jmsTopicSubscriber;
                jmsTopicSubscriber.start();
            } else {
                this.jmsConsumer = new JmsConsumer(this.getConsumerName(), this.getEndpointConfiguration());
            }
        }
        return this.jmsConsumer;
    }

    private TestContextFactory getTestContextFactory() {
        if (this.referenceResolver != null && !this.referenceResolver.resolveAll(TestContextFactoryBean.class).isEmpty()) {
            return (TestContextFactory)this.referenceResolver.resolve(TestContextFactoryBean.class);
        }
        return TestContextFactory.newInstance();
    }

    public Producer createProducer() {
        if (this.jmsProducer == null) {
            this.jmsProducer = new JmsProducer(this.getProducerName(), this.getEndpointConfiguration());
        }
        return this.jmsProducer;
    }

    protected String getSubscriberName() {
        return this.getName() + ":subscriber";
    }

    public JmsEndpointConfiguration getEndpointConfiguration() {
        return (JmsEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void destroy() {
        if (this.jmsConsumer instanceof JmsTopicSubscriber) {
            ((JmsTopicSubscriber)this.jmsConsumer).stop();
        }
    }

    public void initialize() {
        if (this.getEndpointConfiguration().isAutoStart()) {
            Assert.isTrue((boolean)this.getEndpointConfiguration().isPubSubDomain(), (String)"Invalid endpoint configuration - caching subscriber enabled but pubSubDomain is set to false - please enable pubSubDomain");
            this.createConsumer();
        }
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }
}

