/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.endpoint.AbstractPollableEndpointConfiguration;
import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.jms.endpoint.resolver.DynamicDestinationNameResolver;
import com.consol.citrus.jms.message.JmsMessageConverter;
import com.consol.citrus.jms.message.JmsMessageHeaderMapper;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.JmsHeaderMapper;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.util.Assert;

public class JmsEndpointConfiguration
extends AbstractPollableEndpointConfiguration {
    private static Logger log = LoggerFactory.getLogger(JmsEndpointConfiguration.class);
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private String destinationName;
    private DestinationResolver destinationResolver;
    private EndpointUriResolver destinationNameResolver = new DynamicDestinationNameResolver();
    private JmsTemplate jmsTemplate;
    private JmsHeaderMapper headerMapper = new JmsMessageHeaderMapper();
    private JmsMessageConverter messageConverter = new JmsMessageConverter();
    private boolean pubSubDomain = false;
    private boolean autoStart = false;
    private boolean durableSubscription = false;
    private String durableSubscriberName;
    private boolean useObjectMessages = false;

    public String getDestinationName(Destination destination) {
        try {
            if (destination instanceof Queue) {
                return ((Queue)destination).getQueueName();
            }
            if (destination instanceof Topic) {
                return ((Topic)destination).getTopicName();
            }
            return destination.toString();
        }
        catch (JMSException e) {
            log.error("Unable to resolve destination name", (Throwable)e);
            return "";
        }
    }

    private void createJmsTemplate() {
        Assert.isTrue((this.connectionFactory != null ? 1 : 0) != 0, (String)"Neither 'jmsTemplate' nor 'connectionFactory' is set correctly.");
        this.jmsTemplate = new JmsTemplate();
        this.jmsTemplate.setConnectionFactory(this.connectionFactory);
        if (this.destination != null) {
            this.jmsTemplate.setDefaultDestination(this.destination);
        } else if (this.destinationName != null) {
            this.jmsTemplate.setDefaultDestinationName(this.destinationName);
        }
        if (this.destinationResolver != null) {
            this.jmsTemplate.setDestinationResolver(this.destinationResolver);
        }
        this.jmsTemplate.setPubSubDomain(this.pubSubDomain);
    }

    public boolean isPubSubDomain() {
        return this.pubSubDomain;
    }

    public void setPubSubDomain(boolean pubSubDomain) {
        this.pubSubDomain = pubSubDomain;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public DestinationResolver getDestinationResolver() {
        return this.destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }

    public JmsTemplate getJmsTemplate() {
        if (this.jmsTemplate == null) {
            this.createJmsTemplate();
        }
        return this.jmsTemplate;
    }

    public JmsMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(JmsMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public JmsHeaderMapper getHeaderMapper() {
        return this.headerMapper;
    }

    public void setHeaderMapper(JmsHeaderMapper headerMapper) {
        this.headerMapper = headerMapper;
    }

    public boolean isUseObjectMessages() {
        return this.useObjectMessages;
    }

    public void setUseObjectMessages(boolean useObjectMessages) {
        this.useObjectMessages = useObjectMessages;
    }

    public EndpointUriResolver getDestinationNameResolver() {
        return this.destinationNameResolver;
    }

    public void setDestinationNameResolver(EndpointUriResolver destinationNameResolver) {
        this.destinationNameResolver = destinationNameResolver;
    }

    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean isDurableSubscription() {
        return this.durableSubscription;
    }

    public void setDurableSubscription(boolean durableSubscription) {
        this.durableSubscription = durableSubscription;
    }

    public String getDurableSubscriberName() {
        return this.durableSubscriberName;
    }

    public void setDurableSubscriberName(String durableSubscriberName) {
        this.durableSubscriberName = durableSubscriberName;
    }
}

