/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.endpoint.AbstractEndpointBuilder;
import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.jms.endpoint.JmsSyncEndpoint;
import com.consol.citrus.jms.message.JmsMessageConverter;
import com.consol.citrus.message.MessageCorrelator;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.support.destination.DestinationResolver;

public class JmsSyncEndpointBuilder
extends AbstractEndpointBuilder<JmsSyncEndpoint> {
    private JmsSyncEndpoint endpoint = new JmsSyncEndpoint();

    protected JmsSyncEndpoint getEndpoint() {
        return this.endpoint;
    }

    public JmsSyncEndpointBuilder destination(String destinationName) {
        this.endpoint.getEndpointConfiguration().setDestinationName(destinationName);
        return this;
    }

    public JmsSyncEndpointBuilder destination(Destination destination) {
        this.endpoint.getEndpointConfiguration().setDestination(destination);
        return this;
    }

    public JmsSyncEndpointBuilder replyDestination(String destinationName) {
        this.endpoint.getEndpointConfiguration().setReplyDestinationName(destinationName);
        return this;
    }

    public JmsSyncEndpointBuilder replyDestination(Destination destination) {
        this.endpoint.getEndpointConfiguration().setReplyDestination(destination);
        return this;
    }

    public JmsSyncEndpointBuilder connectionFactory(ConnectionFactory connectionFactory) {
        this.endpoint.getEndpointConfiguration().setConnectionFactory(connectionFactory);
        return this;
    }

    public JmsSyncEndpointBuilder jmsTemplate(JmsTemplate jmsTemplate) {
        this.endpoint.getEndpointConfiguration().setJmsTemplate(jmsTemplate);
        return this;
    }

    public JmsSyncEndpointBuilder messageConverter(JmsMessageConverter messageConverter) {
        this.endpoint.getEndpointConfiguration().setMessageConverter(messageConverter);
        return this;
    }

    public JmsSyncEndpointBuilder destinationResolver(DestinationResolver resolver) {
        this.endpoint.getEndpointConfiguration().setDestinationResolver(resolver);
        return this;
    }

    public JmsSyncEndpointBuilder destinationNameResolver(EndpointUriResolver resolver) {
        this.endpoint.getEndpointConfiguration().setDestinationNameResolver(resolver);
        return this;
    }

    public JmsSyncEndpointBuilder pubSubDomain(boolean pubSubDomain) {
        this.endpoint.getEndpointConfiguration().setPubSubDomain(pubSubDomain);
        return this;
    }

    public JmsSyncEndpointBuilder useObjectMessages(boolean useObjectMessages) {
        this.endpoint.getEndpointConfiguration().setUseObjectMessages(useObjectMessages);
        return this;
    }

    public JmsSyncEndpointBuilder filterInternalHeaders(boolean filterInternalHeaders) {
        this.endpoint.getEndpointConfiguration().setFilterInternalHeaders(filterInternalHeaders);
        return this;
    }

    public JmsSyncEndpointBuilder pollingInterval(int pollingInterval) {
        this.endpoint.getEndpointConfiguration().setPollingInterval(pollingInterval);
        return this;
    }

    public JmsSyncEndpointBuilder correlator(MessageCorrelator correlator) {
        this.endpoint.getEndpointConfiguration().setCorrelator(correlator);
        return this;
    }

    public JmsSyncEndpointBuilder timeout(long timeout) {
        this.endpoint.getEndpointConfiguration().setTimeout(timeout);
        return this;
    }
}

