/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.message;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.common.InitializingPhase;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.jms.endpoint.JmsEndpointConfiguration;
import com.consol.citrus.jms.message.JmsMessageConverter;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageHeaderUtils;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.xml.StringResult;
import com.consol.citrus.xml.StringSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import javax.jms.Session;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.SoapMessageFactory;

public class SoapJmsMessageConverter
extends JmsMessageConverter
implements InitializingPhase,
ReferenceResolverAware {
    private static final Logger LOG = LoggerFactory.getLogger(SoapJmsMessageConverter.class);
    private SoapMessageFactory soapMessageFactory;
    private ReferenceResolver referenceResolver;
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final String SOAP_ACTION_HEADER = "citrus_soap_action";
    private String jmsSoapActionHeader = "SOAPJMS_soapAction";

    @Override
    public Message convertInbound(javax.jms.Message jmsMessage, JmsEndpointConfiguration endpointConfiguration, TestContext context) {
        try {
            SoapHeader soapHeader;
            Message message = super.convertInbound(jmsMessage, endpointConfiguration, context);
            ByteArrayInputStream in = new ByteArrayInputStream(((String)message.getPayload(String.class)).getBytes(CitrusSettings.CITRUS_FILE_ENCODING));
            SoapMessage soapMessage = this.soapMessageFactory.createWebServiceMessage((InputStream)in);
            StringResult payload = new StringResult();
            this.transformerFactory.newTransformer().transform(soapMessage.getPayloadSource(), (Result)payload);
            if (message.getHeader(this.jmsSoapActionHeader) != null) {
                message.setHeader(SOAP_ACTION_HEADER, message.getHeader(this.jmsSoapActionHeader));
            }
            if ((soapHeader = soapMessage.getSoapHeader()) != null) {
                Iterator iter = soapHeader.examineAllHeaderElements();
                while (iter.hasNext()) {
                    SoapHeaderElement headerEntry = (SoapHeaderElement)iter.next();
                    MessageHeaderUtils.setHeader((Message)message, (String)headerEntry.getName().getLocalPart(), (String)headerEntry.getText());
                }
                if (soapHeader.getSource() != null) {
                    StringResult headerData = new StringResult();
                    Transformer transformer = this.transformerFactory.newTransformer();
                    transformer.transform(soapHeader.getSource(), (Result)headerData);
                    message.addHeaderData(headerData.toString());
                }
            }
            message.setPayload((Object)payload.toString());
            return message;
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException("Failed to transform SOAP message body to payload", (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CitrusRuntimeException("Found unsupported default encoding", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read SOAP message payload", (Throwable)e);
        }
    }

    @Override
    public javax.jms.Message createJmsMessage(Message message, Session session, JmsEndpointConfiguration endpointConfiguration, TestContext context) {
        String payload = (String)message.getPayload(String.class);
        LOG.debug("Creating SOAP message from payload: " + payload);
        try {
            SoapMessage soapMessage = this.soapMessageFactory.createWebServiceMessage();
            this.transformerFactory.newTransformer().transform((Source)new StringSource(payload), soapMessage.getPayloadResult());
            if (message.getHeader(SOAP_ACTION_HEADER) != null) {
                message.setHeader(this.jmsSoapActionHeader, message.getHeader(SOAP_ACTION_HEADER));
                message.removeHeader(SOAP_ACTION_HEADER);
            }
            for (String headerData : message.getHeaderData()) {
                try {
                    Transformer transformer = this.transformerFactory.newTransformer();
                    transformer.setOutputProperty("omit-xml-declaration", "yes");
                    transformer.transform((Source)new StringSource(headerData), soapMessage.getSoapHeader().getResult());
                }
                catch (TransformerException e) {
                    throw new CitrusRuntimeException("Failed to write SOAP header content", (Throwable)e);
                }
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            soapMessage.writeTo((OutputStream)bos);
            message.setPayload((Object)new String(bos.toByteArray()));
            return super.createJmsMessage(message, session, endpointConfiguration, context);
        }
        catch (TransformerException e) {
            throw new CitrusRuntimeException("Failed to transform payload to SOAP body", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write SOAP message content", (Throwable)e);
        }
    }

    public void setJmsSoapActionHeader(String jmsSoapActionHeader) {
        this.jmsSoapActionHeader = jmsSoapActionHeader;
    }

    public String getJmsSoapActionHeader() {
        return this.jmsSoapActionHeader;
    }

    public void initialize() {
        if (this.soapMessageFactory == null) {
            Assert.notNull((Object)this.referenceResolver, (String)"Missing reference resolver for auto configuration of soap message factory");
            this.soapMessageFactory = (SoapMessageFactory)this.referenceResolver.resolve(SoapMessageFactory.class);
        }
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public SoapMessageFactory getSoapMessageFactory() {
        return this.soapMessageFactory;
    }

    public void setSoapMessageFactory(SoapMessageFactory soapMessageFactory) {
        this.soapMessageFactory = soapMessageFactory;
    }
}

