/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.MessageTimeoutException;
import com.consol.citrus.jms.endpoint.JmsEndpointConfiguration;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.AbstractSelectiveMessageConsumer;
import javax.jms.Destination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JmsConsumer
extends AbstractSelectiveMessageConsumer {
    private static Logger log = LoggerFactory.getLogger(JmsConsumer.class);
    protected final JmsEndpointConfiguration endpointConfiguration;

    public JmsConsumer(String name, JmsEndpointConfiguration endpointConfiguration) {
        super(name, (EndpointConfiguration)endpointConfiguration);
        this.endpointConfiguration = endpointConfiguration;
    }

    public Message receive(String selector, TestContext context, long timeout) {
        javax.jms.Message receivedJmsMessage;
        this.endpointConfiguration.getJmsTemplate().setReceiveTimeout(timeout);
        if (this.endpointConfiguration.getDestination() != null) {
            receivedJmsMessage = this.receive(this.endpointConfiguration.getDestination(), selector);
        } else if (StringUtils.hasText((String)this.endpointConfiguration.getDestinationName())) {
            receivedJmsMessage = this.receive(context.replaceDynamicContentInString(this.endpointConfiguration.getDestinationName()), selector);
        } else if (this.endpointConfiguration.getJmsTemplate().getDefaultDestination() != null) {
            receivedJmsMessage = this.receive(this.endpointConfiguration.getJmsTemplate().getDefaultDestination(), selector);
        } else if (StringUtils.hasText((String)this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName())) {
            receivedJmsMessage = this.receive(context.replaceDynamicContentInString(this.endpointConfiguration.getJmsTemplate().getDefaultDestinationName()), selector);
        } else {
            throw new CitrusRuntimeException("Unable to receive message - JMS destination not set");
        }
        Message receivedMessage = this.endpointConfiguration.getMessageConverter().convertInbound(receivedJmsMessage, this.endpointConfiguration, context);
        context.onInboundMessage(receivedMessage);
        return receivedMessage;
    }

    private javax.jms.Message receive(String destinationName, String selector) {
        javax.jms.Message receivedJmsMessage;
        if (log.isDebugEnabled()) {
            log.debug("Receiving JMS message on destination: '" + this.getDestinationNameWithSelector(destinationName, selector) + "'");
        }
        if ((receivedJmsMessage = StringUtils.hasText((String)selector) ? this.endpointConfiguration.getJmsTemplate().receiveSelected(destinationName, selector) : this.endpointConfiguration.getJmsTemplate().receive(destinationName)) == null) {
            throw new MessageTimeoutException(this.endpointConfiguration.getTimeout(), this.getDestinationNameWithSelector(destinationName, selector));
        }
        log.info("Received JMS message on destination: '" + this.getDestinationNameWithSelector(destinationName, selector) + "'");
        return receivedJmsMessage;
    }

    private javax.jms.Message receive(Destination destination, String selector) {
        javax.jms.Message receivedJmsMessage;
        if (log.isDebugEnabled()) {
            log.debug("Receiving JMS message on destination: '" + this.getDestinationNameWithSelector(this.endpointConfiguration.getDestinationName(destination), selector) + "'");
        }
        if ((receivedJmsMessage = StringUtils.hasText((String)selector) ? this.endpointConfiguration.getJmsTemplate().receiveSelected(destination, selector) : this.endpointConfiguration.getJmsTemplate().receive(destination)) == null) {
            throw new MessageTimeoutException(this.endpointConfiguration.getTimeout(), this.getDestinationNameWithSelector(this.endpointConfiguration.getDestinationName(destination), selector));
        }
        log.info("Received JMS message on destination: '" + this.getDestinationNameWithSelector(this.endpointConfiguration.getDestinationName(destination), selector) + "'");
        return receivedJmsMessage;
    }

    private String getDestinationNameWithSelector(String destinationName, String selector) {
        return destinationName + (String)(StringUtils.hasText((String)selector) ? "(" + selector + ")" : "");
    }
}

