/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.AbstractEndpointAdapter;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.ActionTimeoutException;
import com.consol.citrus.jms.endpoint.JmsSyncEndpoint;
import com.consol.citrus.jms.endpoint.JmsSyncEndpointConfiguration;
import com.consol.citrus.jms.endpoint.JmsSyncProducer;
import com.consol.citrus.jms.message.JmsMessageHeaderMapper;
import com.consol.citrus.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsEndpointAdapter
extends AbstractEndpointAdapter {
    private final JmsSyncEndpoint endpoint;
    private final JmsSyncProducer producer;
    private final JmsSyncEndpointConfiguration endpointConfiguration;
    private static final Logger LOG = LoggerFactory.getLogger(JmsEndpointAdapter.class);

    public JmsEndpointAdapter(JmsSyncEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
        if (this.endpointConfiguration.getHeaderMapper() instanceof JmsMessageHeaderMapper) {
            this.endpointConfiguration.setFilterInternalHeaders(false);
        }
        this.endpoint = new JmsSyncEndpoint(this.endpointConfiguration);
        this.endpoint.setName(this.getName());
        this.producer = new JmsSyncProducer(this.endpoint.getProducerName(), this.endpointConfiguration);
    }

    protected Message handleMessageInternal(Message request) {
        LOG.debug("Forwarding request to jms destination ...");
        TestContext context = this.getTestContext();
        Message replyMessage = null;
        try {
            this.producer.send(request, context);
            replyMessage = this.endpointConfiguration.getCorrelator() != null ? this.producer.receive(this.endpointConfiguration.getCorrelator().getCorrelationKey(request), context, this.endpointConfiguration.getTimeout()) : this.producer.receive(context, this.endpointConfiguration.getTimeout());
        }
        catch (ActionTimeoutException e) {
            LOG.warn(e.getMessage());
        }
        return replyMessage;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public JmsSyncEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }
}

