/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.jms.message;

import java.util.HashMap;
import java.util.Map;
import javax.jms.Message;
import org.springframework.jms.support.SimpleJmsHeaderMapper;
import org.springframework.messaging.MessageHeaders;

public class JmsMessageHeaderMapper
extends SimpleJmsHeaderMapper {
    private boolean filterInternalHeaders = true;

    public void fromHeaders(MessageHeaders headers, Message jmsMessage) {
        HashMap<String, Object> integrationHeaders = new HashMap<String, Object>();
        if (headers.get((Object)"citrus_jms_correlationId") != null) {
            integrationHeaders.put("jms_correlationId", headers.get((Object)"citrus_jms_correlationId"));
        }
        if (headers.get((Object)"citrus_jms_messageId") != null) {
            integrationHeaders.put("jms_messageId", headers.get((Object)"citrus_jms_messageId"));
        }
        if (headers.get((Object)"citrus_jms_replyTo") != null) {
            integrationHeaders.put("jms_replyTo", headers.get((Object)"citrus_jms_replyTo"));
        }
        if (headers.get((Object)"citrus_jms_timestamp") != null) {
            integrationHeaders.put("jms_timestamp", headers.get((Object)"citrus_jms_timestamp"));
        }
        if (headers.get((Object)"citrus_jms_type") != null) {
            integrationHeaders.put("jms_type", headers.get((Object)"citrus_jms_type"));
        }
        if (headers.get((Object)"citrus_jms_redelivered") != null) {
            integrationHeaders.put("jms_redelivered", headers.get((Object)"citrus_jms_redelivered"));
        }
        if (headers.get((Object)"citrus_jms_priority") != null) {
            integrationHeaders.put("jms_priority", headers.get((Object)"citrus_jms_priority"));
        }
        if (headers.get((Object)"citrus_jms_destination") != null) {
            integrationHeaders.put("jms_destination", headers.get((Object)"citrus_jms_destination"));
        }
        if (headers.get((Object)"citrus_jms_deliveryMode") != null) {
            integrationHeaders.put("jms_deliveryMode", headers.get((Object)"citrus_jms_deliveryMode"));
        }
        if (headers.get((Object)"citrus_jms_expiration") != null) {
            integrationHeaders.put("jms_expiration", headers.get((Object)"citrus_jms_expiration"));
        }
        for (Map.Entry headerEntry : headers.entrySet()) {
            if (this.filterInternalHeaders) {
                if (((String)headerEntry.getKey()).startsWith("citrus_")) continue;
                integrationHeaders.put((String)headerEntry.getKey(), headerEntry.getValue());
                continue;
            }
            if (((String)headerEntry.getKey()).equals("citrus_message_id") || ((String)headerEntry.getKey()).equals("citrus_message_timestamp")) continue;
            integrationHeaders.put((String)headerEntry.getKey(), headerEntry.getValue());
        }
        super.fromHeaders(new MessageHeaders(integrationHeaders), jmsMessage);
    }

    public MessageHeaders toHeaders(Message jmsMessage) {
        HashMap internalHeaders = new HashMap();
        MessageHeaders jmsHeaders = super.toHeaders(jmsMessage);
        if (jmsHeaders.get("jms_correlationId") != null) {
            internalHeaders.put("citrus_jms_correlationId", jmsHeaders.get("jms_correlationId"));
        }
        if (jmsHeaders.get("jms_messageId") != null) {
            internalHeaders.put("citrus_jms_messageId", jmsHeaders.get("jms_messageId"));
        }
        if (jmsHeaders.get("jms_replyTo") != null) {
            internalHeaders.put("citrus_jms_replyTo", jmsHeaders.get("jms_replyTo"));
        }
        if (jmsHeaders.get("jms_timestamp") != null) {
            internalHeaders.put("citrus_jms_timestamp", jmsHeaders.get("jms_timestamp"));
        }
        if (jmsHeaders.get("jms_type") != null) {
            internalHeaders.put("citrus_jms_type", jmsHeaders.get("jms_type"));
        }
        if (jmsHeaders.get("jms_redelivered") != null) {
            internalHeaders.put("citrus_jms_redelivered", jmsHeaders.get("jms_redelivered"));
        }
        if (jmsHeaders.get("jms_priority") != null) {
            internalHeaders.put("citrus_jms_priority", jmsHeaders.get("jms_priority"));
        }
        if (jmsHeaders.get("jms_destination") != null) {
            internalHeaders.put("citrus_jms_destination", jmsHeaders.get("jms_destination"));
        }
        if (jmsHeaders.get("jms_deliveryMode") != null) {
            internalHeaders.put("citrus_jms_deliveryMode", jmsHeaders.get("jms_deliveryMode"));
        }
        if (jmsHeaders.get("jms_expiration") != null) {
            internalHeaders.put("citrus_jms_expiration", jmsHeaders.get("jms_expiration"));
        }
        for (Map.Entry headerEntry : jmsHeaders.entrySet()) {
            if (((String)headerEntry.getKey()).startsWith("jms_")) continue;
            internalHeaders.put((String)headerEntry.getKey(), headerEntry.getValue());
        }
        return new MessageHeaders(internalHeaders);
    }

    public void setFilterInternalHeaders(boolean filterInternalHeaders) {
        this.filterInternalHeaders = filterInternalHeaders;
    }
}

