/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.TestBehavior;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.junit.AbstractJUnit4CitrusTest;
import com.consol.citrus.junit.CitrusJUnit4Runner;
import java.lang.reflect.Method;
import java.util.Date;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

public class JUnit4CitrusSupport
extends AbstractJUnit4CitrusTest
implements GherkinTestActionRunner {
    private static final String BUILDER_ATTRIBUTE = "builder";
    private TestCaseRunner testCaseRunner;

    @Override
    protected void run(CitrusJUnit4Runner.CitrusFrameworkMethod frameworkMethod) {
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)this.applicationContext));
        }
        TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
        TestCaseRunner testCaseBuilder = this.createTestRunner(frameworkMethod, ctx);
        frameworkMethod.setAttribute(BUILDER_ATTRIBUTE, testCaseBuilder);
        CitrusAnnotations.injectAll((Object)((Object)this), (Citrus)this.citrus, (TestContext)ctx);
        this.invokeTestMethod(frameworkMethod, testCaseBuilder, ctx);
    }

    protected void invokeTestMethod(CitrusJUnit4Runner.CitrusFrameworkMethod frameworkMethod, TestCaseRunner testCaseBuilder, TestContext context) {
        TestCase testCase = testCaseBuilder.getTestCase();
        try {
            Object[] params = this.resolveParameter(frameworkMethod, testCase, context);
            testCaseBuilder.start();
            ReflectionUtils.invokeMethod((Method)frameworkMethod.getMethod(), (Object)((Object)this), (Object[])params);
        }
        catch (AssertionError | Exception e) {
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
            throw new TestCaseFailedException((Throwable)e);
        }
        finally {
            testCaseBuilder.stop();
        }
    }

    @Override
    protected Object resolveAnnotatedResource(CitrusJUnit4Runner.CitrusFrameworkMethod frameworkMethod, Class<?> parameterType, TestContext context) {
        Object storedBuilder = frameworkMethod.getAttribute(BUILDER_ATTRIBUTE);
        if (TestCaseRunner.class.isAssignableFrom(parameterType)) {
            return storedBuilder;
        }
        if (TestActionRunner.class.isAssignableFrom(parameterType) && storedBuilder instanceof TestActionRunner) {
            return storedBuilder;
        }
        if (GherkinTestActionRunner.class.isAssignableFrom(parameterType) && storedBuilder instanceof GherkinTestActionRunner) {
            return storedBuilder;
        }
        return super.resolveAnnotatedResource(frameworkMethod, parameterType, context);
    }

    protected TestCaseRunner createTestRunner(CitrusJUnit4Runner.CitrusFrameworkMethod frameworkMethod, TestContext context) {
        this.testCaseRunner = new DefaultTestCaseRunner((TestCase)new DefaultTestCase(), context);
        this.testCaseRunner.testClass(((Object)((Object)this)).getClass());
        this.testCaseRunner.name(frameworkMethod.getTestName());
        this.testCaseRunner.packageName(frameworkMethod.getPackageName());
        return this.testCaseRunner;
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.testCaseRunner.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.testCaseRunner.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.testCaseRunner.variable(name, value);
    }

    public void name(String name) {
        this.testCaseRunner.name(name);
    }

    public void description(String description) {
        this.testCaseRunner.description(description);
    }

    public void author(String author) {
        this.testCaseRunner.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.testCaseRunner.status(status);
    }

    public void creationDate(Date date) {
        this.testCaseRunner.creationDate(date);
    }
}

