/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.junit.TestSuiteState;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

public class TestSuiteExecutionListener
extends AbstractTestExecutionListener {
    private static final String SUITE_NAME = "citrus-junit4-suite";

    public void prepareTestInstance(TestContext testContext) throws Exception {
        if (TestSuiteState.shouldExecuteBeforeSuite()) {
            ApplicationContext ctx = testContext.getApplicationContext();
            Citrus citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)ctx));
            citrus.beforeSuite(SUITE_NAME, new String[0]);
            Runtime.getRuntime().addShutdownHook(new Thread(new AfterSuiteShutdownHook(citrus)));
        }
    }

    private static class AfterSuiteShutdownHook
    implements Runnable {
        private final Citrus citrus;

        public AfterSuiteShutdownHook(Citrus citrus) {
            this.citrus = citrus;
        }

        @Override
        public void run() {
            this.citrus.afterSuite(TestSuiteExecutionListener.SUITE_NAME, new String[0]);
        }
    }
}

