/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit;

import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestResult;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.junit.CitrusFrameworkMethod;
import com.consol.citrus.junit.JUnit4ParameterHelper;
import java.lang.reflect.Method;
import org.springframework.util.ReflectionUtils;

public final class JUnit4Helper {
    public static final String BUILDER_ATTRIBUTE = "builder";

    private JUnit4Helper() {
    }

    public static void invokeTestMethod(Object target, CitrusFrameworkMethod frameworkMethod, TestCaseRunner runner, TestContext context) {
        TestCase testCase = runner.getTestCase();
        try {
            Object[] params = JUnit4ParameterHelper.resolveParameter(frameworkMethod, testCase, context);
            runner.start();
            ReflectionUtils.invokeMethod((Method)frameworkMethod.getMethod(), (Object)target, (Object[])params);
        }
        catch (AssertionError | Exception e) {
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
            throw new TestCaseFailedException((Throwable)e);
        }
        finally {
            runner.stop();
        }
    }

    public static TestCaseRunner createTestRunner(CitrusFrameworkMethod frameworkMethod, Class<?> testClass, TestContext context) {
        DefaultTestCaseRunner testCaseRunner = new DefaultTestCaseRunner((TestCase)new DefaultTestCase(), context);
        testCaseRunner.testClass(testClass);
        testCaseRunner.name(frameworkMethod.getTestName());
        testCaseRunner.packageName(frameworkMethod.getPackageName());
        return testCaseRunner;
    }
}

