/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.spring;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.junit.CitrusFrameworkMethod;
import com.consol.citrus.junit.TestSuiteExecutionListener;
import com.consol.citrus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.StringUtils;

public class CitrusSpringJUnit4Runner
extends SpringJUnit4ClassRunner {
    private static final Logger LOG = LoggerFactory.getLogger(CitrusSpringJUnit4Runner.class);

    public CitrusSpringJUnit4Runner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.getTestContextManager().registerTestExecutionListeners(new TestExecutionListener[]{new TestSuiteExecutionListener()});
    }

    protected Statement methodInvoker(FrameworkMethod frameworkMethod, Object testInstance) {
        return new InvokeRunMethod(frameworkMethod, testInstance);
    }

    protected List<FrameworkMethod> getChildren() {
        List methods = super.getChildren();
        ArrayList<FrameworkMethod> interceptedMethods = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod method : methods) {
            if (method.getMethod().getAnnotation(CitrusXmlTest.class) != null) {
                CitrusXmlTest citrusXmlTestAnnotation = method.getMethod().getAnnotation(CitrusXmlTest.class);
                String[] packagesToScan = citrusXmlTestAnnotation.packageScan();
                String packageName = method.getMethod().getDeclaringClass().getPackage().getName();
                if (StringUtils.hasText((String)citrusXmlTestAnnotation.packageName())) {
                    packageName = citrusXmlTestAnnotation.packageName();
                }
                if (citrusXmlTestAnnotation.name().length > 0) {
                    for (int i = 0; i < citrusXmlTestAnnotation.name().length; ++i) {
                        interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), citrusXmlTestAnnotation.name()[i], packageName));
                    }
                } else if (packagesToScan.length == 0) {
                    interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), method.getName(), packageName));
                }
                for (String packageScan : packagesToScan) {
                    try {
                        for (String fileNamePattern : CitrusSettings.getXmlTestFileNamePattern()) {
                            Resource[] fileResources;
                            for (Resource fileResource : fileResources = new PathMatchingResourcePatternResolver().getResources(packageScan.replace('.', File.separatorChar) + fileNamePattern)) {
                                Object filePath = fileResource.getFile().getParentFile().getCanonicalPath();
                                if (packageScan.startsWith("file:")) {
                                    filePath = "file:" + (String)filePath;
                                }
                                filePath = ((String)filePath).substring(((String)filePath).indexOf(packageScan.replace('.', File.separatorChar)));
                                interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), FileUtils.getBaseName((String)fileResource.getFilename()), (String)filePath));
                            }
                        }
                    }
                    catch (IOException | RuntimeException e) {
                        LOG.error("Unable to locate file resources for test package '" + packageScan + "'", (Throwable)e);
                    }
                }
                continue;
            }
            if (method.getMethod().getAnnotation(CitrusTest.class) != null) {
                CitrusTest citrusTestAnnotation = method.getMethod().getAnnotation(CitrusTest.class);
                if (StringUtils.hasText((String)citrusTestAnnotation.name())) {
                    interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), citrusTestAnnotation.name(), method.getMethod().getDeclaringClass().getPackage().getName()));
                    continue;
                }
                interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), method.getDeclaringClass().getSimpleName() + "." + method.getName(), method.getMethod().getDeclaringClass().getPackage().getName()));
                continue;
            }
            interceptedMethods.add(method);
        }
        return interceptedMethods;
    }

    protected void validateTestMethods(List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(Test.class);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoid(false, errors);
        }
    }

    private static class InvokeRunMethod
    extends InvokeMethod {
        private final FrameworkMethod frameworkMethod;
        private final Object testInstance;

        public InvokeRunMethod(FrameworkMethod frameworkMethod, Object testInstance) {
            super(frameworkMethod, testInstance);
            this.frameworkMethod = frameworkMethod;
            this.testInstance = testInstance;
        }

        public void evaluate() throws Throwable {
            if (CitrusFrameworkMethod.Runner.class.isAssignableFrom(this.testInstance.getClass()) && this.frameworkMethod instanceof CitrusFrameworkMethod) {
                ((CitrusFrameworkMethod.Runner)this.testInstance).run((CitrusFrameworkMethod)this.frameworkMethod);
            } else {
                super.evaluate();
            }
        }
    }
}

