/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.spring;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusContextProvider;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.CitrusSpringContextProvider;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestBehavior;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.TestSourceAware;
import com.consol.citrus.common.XmlTestLoader;
import com.consol.citrus.config.CitrusSpringConfig;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.junit.CitrusFrameworkMethod;
import com.consol.citrus.junit.JUnit4Helper;
import com.consol.citrus.junit.spring.CitrusSpringJUnit4Runner;
import java.util.Date;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;

@RunWith(value=CitrusSpringJUnit4Runner.class)
@ContextConfiguration(classes={CitrusSpringConfig.class})
public class JUnit4CitrusSpringSupport
extends AbstractJUnit4SpringContextTests
implements GherkinTestActionRunner,
CitrusFrameworkMethod.Runner {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Citrus citrus;
    private TestCaseRunner delegate;

    @Override
    public void run(CitrusFrameworkMethod frameworkMethod) {
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(this.applicationContext));
        }
        TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
        if (frameworkMethod.getMethod().getAnnotation(CitrusXmlTest.class) != null) {
            TestLoader testLoader = this.createTestLoader(frameworkMethod.getTestName(), frameworkMethod.getPackageName());
            if (testLoader instanceof TestSourceAware) {
                ((TestSourceAware)testLoader).setSource(frameworkMethod.getSource());
            }
            TestCase testCase = testLoader.load();
            this.citrus.run((TestAction)testCase, ctx);
        } else if (frameworkMethod.getMethod().getAnnotation(CitrusTest.class) != null) {
            TestCaseRunner runner = JUnit4Helper.createTestRunner(frameworkMethod, this.getClass(), ctx);
            frameworkMethod.setAttribute("builder", runner);
            this.delegate = runner;
            CitrusAnnotations.injectAll((Object)this, (Citrus)this.citrus, (TestContext)ctx);
            JUnit4Helper.invokeTestMethod(this, frameworkMethod, runner, ctx);
        }
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    protected TestLoader createTestLoader(String testName, String packageName) {
        return new XmlTestLoader(this.getClass(), testName, packageName, (CitrusContext)CitrusSpringContext.create((ApplicationContext)this.applicationContext));
    }

    protected TestCase getTestCase() {
        return this.createTestLoader(this.getClass().getSimpleName(), this.getClass().getPackage().getName()).load();
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.delegate.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.delegate.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.delegate.variable(name, value);
    }

    public void name(String name) {
        this.delegate.name(name);
    }

    public void description(String description) {
        this.delegate.description(description);
    }

    public void author(String author) {
        this.delegate.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.delegate.status(status);
    }

    public void creationDate(Date date) {
        this.delegate.creationDate(date);
    }
}

