/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit;

import com.consol.citrus.Citrus;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestBehavior;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusTestSource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.DefaultTestLoader;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.TestSourceAware;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.junit.CitrusFrameworkMethod;
import com.consol.citrus.junit.CitrusJUnit4Runner;
import com.consol.citrus.junit.JUnit4Helper;
import java.util.Date;
import org.junit.runner.RunWith;

@RunWith(value=CitrusJUnit4Runner.class)
public class JUnit4CitrusSupport
implements GherkinTestActionRunner,
CitrusFrameworkMethod.Runner {
    protected Citrus citrus;
    private TestCaseRunner delegate;

    @Override
    public void run(CitrusFrameworkMethod frameworkMethod) {
        if (frameworkMethod.hasError()) {
            throw frameworkMethod.getError();
        }
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance();
        }
        TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
        if (frameworkMethod.getMethod().getAnnotation(CitrusTest.class) != null || frameworkMethod.getMethod().getAnnotation(CitrusTestSource.class) != null) {
            DefaultTestLoader testLoader;
            TestCaseRunner runner = JUnit4Helper.createTestRunner(frameworkMethod, this.getClass(), ctx);
            frameworkMethod.setAttribute("builder", runner);
            this.delegate = runner;
            CitrusAnnotations.injectAll((Object)this, (Citrus)this.citrus, (TestContext)ctx);
            if (frameworkMethod.getMethod().getAnnotation(CitrusTestSource.class) != null) {
                testLoader = this.createTestLoader(frameworkMethod.getTestName(), frameworkMethod.getPackageName(), frameworkMethod.getSource(), frameworkMethod.getSourceType());
                CitrusAnnotations.injectTestRunner((Object)testLoader, (TestCaseRunner)runner);
            } else {
                testLoader = new DefaultTestLoader();
            }
            CitrusAnnotations.injectAll((Object)testLoader, (Citrus)this.citrus, (TestContext)ctx);
            testLoader.doWithTestCase(t -> JUnit4Helper.invokeTestMethod(this, frameworkMethod, ctx));
            testLoader.load();
        } else if (frameworkMethod.getMethod().getAnnotation(CitrusXmlTest.class) != null) {
            throw new CitrusRuntimeException("Unsupported XML test annotation - please add Spring support");
        }
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    protected TestLoader createTestLoader(String testName, String packageName, String source, String type) {
        TestLoader testLoader = (TestLoader)TestLoader.lookup((String)type).orElseThrow(() -> new CitrusRuntimeException(String.format("Missing test loader for type '%s'", type)));
        testLoader.setTestClass(this.getClass());
        testLoader.setTestName(testName);
        testLoader.setPackageName(packageName);
        if (testLoader instanceof TestSourceAware) {
            ((TestSourceAware)testLoader).setSource(source);
        }
        return testLoader;
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.delegate.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.delegate.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.delegate.variable(name, value);
    }

    public void name(String name) {
        this.delegate.name(name);
    }

    public void description(String description) {
        this.delegate.description(description);
    }

    public void author(String author) {
        this.delegate.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.delegate.status(status);
    }

    public void creationDate(Date date) {
        this.delegate.creationDate(date);
    }
}

