/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit;

import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.junit.CitrusFrameworkMethod;
import java.lang.annotation.Annotation;

public final class JUnit4ParameterHelper {
    private JUnit4ParameterHelper() {
    }

    public static Object resolveAnnotatedResource(CitrusFrameworkMethod frameworkMethod, Class<?> parameterType, TestContext context) {
        Object storedBuilder = frameworkMethod.getAttribute("builder");
        if (TestCaseRunner.class.isAssignableFrom(parameterType)) {
            return storedBuilder;
        }
        if (TestActionRunner.class.isAssignableFrom(parameterType) && storedBuilder instanceof TestActionRunner) {
            return storedBuilder;
        }
        if (GherkinTestActionRunner.class.isAssignableFrom(parameterType) && storedBuilder instanceof GherkinTestActionRunner) {
            return storedBuilder;
        }
        if (TestContext.class.isAssignableFrom(parameterType)) {
            return context;
        }
        throw new CitrusRuntimeException("Not able to provide a Citrus resource injection for type " + parameterType);
    }

    public static Object[] resolveParameter(CitrusFrameworkMethod frameworkMethod, TestContext context) {
        Object[] values = new Object[frameworkMethod.getMethod().getParameterTypes().length];
        Class<?>[] parameterTypes = frameworkMethod.getMethod().getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Annotation[] parameterAnnotations = frameworkMethod.getMethod().getParameterAnnotations()[i];
            Class<?> parameterType = parameterTypes[i];
            for (Annotation annotation : parameterAnnotations) {
                if (!(annotation instanceof CitrusResource)) continue;
                values[i] = JUnit4ParameterHelper.resolveAnnotatedResource(frameworkMethod, parameterType, context);
            }
        }
        return values;
    }
}

