/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.spring;

import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusTestSource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.junit.CitrusFrameworkMethod;
import com.consol.citrus.junit.JUnit4Helper;
import com.consol.citrus.junit.TestSuiteExecutionListener;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.util.StringUtils;

public class CitrusSpringJUnit4Runner
extends SpringJUnit4ClassRunner {
    public CitrusSpringJUnit4Runner(Class<?> clazz) throws InitializationError {
        super(clazz);
        this.getTestContextManager().registerTestExecutionListeners(new TestExecutionListener[]{new TestSuiteExecutionListener()});
    }

    protected Statement methodInvoker(FrameworkMethod frameworkMethod, Object testInstance) {
        return new InvokeRunMethod(frameworkMethod, testInstance);
    }

    protected List<FrameworkMethod> getChildren() {
        List methods = super.getChildren();
        ArrayList<FrameworkMethod> interceptedMethods = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod method : methods) {
            CitrusTest citrusTestAnnotation;
            if (method.getMethod().getAnnotation(CitrusTest.class) != null) {
                citrusTestAnnotation = method.getMethod().getAnnotation(CitrusTest.class);
                if (StringUtils.hasText((String)citrusTestAnnotation.name())) {
                    interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), citrusTestAnnotation.name(), method.getMethod().getDeclaringClass().getPackage().getName()));
                    continue;
                }
                interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), method.getDeclaringClass().getSimpleName() + "." + method.getName(), method.getMethod().getDeclaringClass().getPackage().getName()));
                continue;
            }
            if (method.getMethod().getAnnotation(CitrusTestSource.class) != null) {
                citrusTestAnnotation = method.getMethod().getAnnotation(CitrusTestSource.class);
                interceptedMethods.addAll(JUnit4Helper.findInterceptedMethods(method, citrusTestAnnotation.type(), citrusTestAnnotation.name(), citrusTestAnnotation.packageName(), citrusTestAnnotation.packageScan(), citrusTestAnnotation.sources()));
                continue;
            }
            if (method.getMethod().getAnnotation(CitrusXmlTest.class) != null) {
                citrusTestAnnotation = method.getMethod().getAnnotation(CitrusXmlTest.class);
                interceptedMethods.addAll(JUnit4Helper.findInterceptedMethods(method, "spring", citrusTestAnnotation.name(), citrusTestAnnotation.packageName(), citrusTestAnnotation.packageScan(), citrusTestAnnotation.sources()));
                continue;
            }
            interceptedMethods.add(method);
        }
        return interceptedMethods;
    }

    protected void validateTestMethods(List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(Test.class);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoid(false, errors);
        }
    }

    private static class InvokeRunMethod
    extends InvokeMethod {
        private final FrameworkMethod frameworkMethod;
        private final Object testInstance;

        public InvokeRunMethod(FrameworkMethod frameworkMethod, Object testInstance) {
            super(frameworkMethod, testInstance);
            this.frameworkMethod = frameworkMethod;
            this.testInstance = testInstance;
        }

        public void evaluate() throws Throwable {
            if (CitrusFrameworkMethod.Runner.class.isAssignableFrom(this.testInstance.getClass()) && this.frameworkMethod instanceof CitrusFrameworkMethod) {
                ((CitrusFrameworkMethod.Runner)this.testInstance).run((CitrusFrameworkMethod)this.frameworkMethod);
            } else {
                super.evaluate();
            }
        }
    }
}

