/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit;

import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusTestSource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.junit.CitrusFrameworkMethod;
import com.consol.citrus.junit.JUnit4Helper;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.junit.internal.runners.statements.InvokeMethod;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.springframework.util.StringUtils;

public class CitrusJUnit4Runner
extends BlockJUnit4ClassRunner {
    public CitrusJUnit4Runner(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    protected Statement methodInvoker(FrameworkMethod frameworkMethod, Object testInstance) {
        return new InvokeRunMethod(frameworkMethod, testInstance);
    }

    protected List<FrameworkMethod> getChildren() {
        List methods = super.getChildren();
        ArrayList<FrameworkMethod> interceptedMethods = new ArrayList<FrameworkMethod>();
        for (FrameworkMethod method : methods) {
            CitrusTest citrusTestAnnotation;
            if (method.getMethod().getAnnotation(CitrusTest.class) != null) {
                citrusTestAnnotation = method.getMethod().getAnnotation(CitrusTest.class);
                if (StringUtils.hasText((String)citrusTestAnnotation.name())) {
                    interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), citrusTestAnnotation.name(), method.getMethod().getDeclaringClass().getPackage().getName()));
                    continue;
                }
                interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), method.getDeclaringClass().getSimpleName() + "." + method.getName(), method.getMethod().getDeclaringClass().getPackage().getName()));
                continue;
            }
            if (method.getMethod().getAnnotation(CitrusTestSource.class) != null) {
                citrusTestAnnotation = method.getMethod().getAnnotation(CitrusTestSource.class);
                interceptedMethods.addAll(JUnit4Helper.findInterceptedMethods(method, citrusTestAnnotation.type(), citrusTestAnnotation.name(), citrusTestAnnotation.packageName(), citrusTestAnnotation.packageScan(), citrusTestAnnotation.sources()));
                continue;
            }
            if (method.getMethod().getAnnotation(CitrusXmlTest.class) != null) {
                interceptedMethods.add(new CitrusFrameworkMethod(method.getMethod(), "spring", method.getName(), method.getMethod().getDeclaringClass().getPackage().getName()).withError((RuntimeException)new CitrusRuntimeException("Unsupported XML test annotation - please add Spring support")));
                continue;
            }
            interceptedMethods.add(method);
        }
        return interceptedMethods;
    }

    protected void validateTestMethods(List<Throwable> errors) {
        List methods = this.getTestClass().getAnnotatedMethods(Test.class);
        for (FrameworkMethod eachTestMethod : methods) {
            eachTestMethod.validatePublicVoid(false, errors);
        }
    }

    private static class InvokeRunMethod
    extends InvokeMethod {
        private final FrameworkMethod frameworkMethod;
        private final Object testInstance;

        public InvokeRunMethod(FrameworkMethod frameworkMethod, Object testInstance) {
            super(frameworkMethod, testInstance);
            this.frameworkMethod = frameworkMethod;
            this.testInstance = testInstance;
        }

        public void evaluate() throws Throwable {
            if (CitrusFrameworkMethod.Runner.class.isAssignableFrom(this.testInstance.getClass()) && this.frameworkMethod instanceof CitrusFrameworkMethod) {
                ((CitrusFrameworkMethod.Runner)this.testInstance).run((CitrusFrameworkMethod)this.frameworkMethod);
            } else {
                super.evaluate();
            }
        }
    }
}

