/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.jupiter;

import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.junit.jupiter.CitrusBaseExtension;
import java.lang.reflect.Method;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CitrusSupport
extends CitrusBaseExtension
implements TestExecutionExceptionHandler {
    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        if (!CitrusSupport.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            TestCase testCase = CitrusSupport.getTestCase(extensionContext);
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)throwable));
        }
        throw throwable;
    }

    @Override
    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        if (!CitrusSupport.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            TestCase testCase = CitrusSupport.getTestCase(extensionContext);
            extensionContext.getExecutionException().ifPresent(e -> testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e)));
            CitrusSupport.getTestRunner(extensionContext).stop();
            extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusSupport.getBaseKey(extensionContext) + TestCaseRunner.class.getSimpleName()));
        }
        super.afterTestExecution(extensionContext);
    }

    @Override
    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        if (CitrusSupport.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            super.beforeTestExecution(extensionContext);
        }
        TestCaseRunner testRunner = CitrusSupport.getTestRunner(extensionContext);
        CitrusAnnotations.injectTestRunner((Object)extensionContext.getRequiredTestInstance(), (TestCaseRunner)testRunner);
    }

    @Override
    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        if (CitrusSupport.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
            super.beforeEach(extensionContext);
        } else {
            CitrusSupport.getTestContext(extensionContext);
            TestCase testCase = CitrusSupport.getTestCase(extensionContext);
            TestCaseRunner testRunner = CitrusSupport.getTestRunner(extensionContext);
            try {
                testRunner.start();
            }
            catch (AssertionError | Exception e) {
                CitrusSupport.getTestCase(extensionContext).setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
                throw new TestCaseFailedException((Throwable)e);
            }
        }
    }

    @Override
    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        TestCaseRunner storedBuilder = CitrusSupport.getTestRunner(extensionContext);
        if (TestCaseRunner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return storedBuilder;
        }
        if (TestActionRunner.class.isAssignableFrom(parameterContext.getParameter().getType()) && storedBuilder instanceof TestActionRunner) {
            return storedBuilder;
        }
        if (GherkinTestActionRunner.class.isAssignableFrom(parameterContext.getParameter().getType()) && storedBuilder instanceof GherkinTestActionRunner) {
            return storedBuilder;
        }
        return super.resolveParameter(parameterContext, extensionContext);
    }

    protected static TestCaseRunner getTestRunner(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCaseRunner)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)(CitrusSupport.getBaseKey(extensionContext) + TestCaseRunner.class.getSimpleName()), key -> {
            CitrusTest citrusTestAnnotation;
            String testName = extensionContext.getRequiredTestClass().getSimpleName() + "." + extensionContext.getRequiredTestMethod().getName();
            if (extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class) != null && StringUtils.hasText((String)(citrusTestAnnotation = extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class)).name())) {
                testName = citrusTestAnnotation.name();
            }
            DefaultTestCaseRunner testCaseRunner = new DefaultTestCaseRunner((TestCase)new DefaultTestCase(), CitrusSupport.getTestContext(extensionContext));
            testCaseRunner.testClass(extensionContext.getRequiredTestClass());
            testCaseRunner.name(testName);
            testCaseRunner.packageName(extensionContext.getRequiredTestClass().getPackage().getName());
            return testCaseRunner;
        }, TestCaseRunner.class);
    }

    protected static TestCase getTestCase(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCase)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)(CitrusSupport.getBaseKey(extensionContext) + TestCase.class.getSimpleName()), key -> {
            if (CitrusSupport.isXmlTestMethod(extensionContext.getRequiredTestMethod())) {
                return CitrusBaseExtension.getXmlTestCase(extensionContext);
            }
            return CitrusSupport.getTestRunner(extensionContext).getTestCase();
        }, TestCase.class);
    }

    private static boolean isXmlTestMethod(Method method) {
        return method.isAnnotationPresent(CitrusXmlTest.class) || method.isAnnotationPresent(TestFactory.class);
    }
}

