/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.jupiter.spring;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusSettings;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.TestAction;
import com.consol.citrus.common.XmlTestLoader;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.junit.jupiter.CitrusExtensionHelper;
import com.consol.citrus.junit.jupiter.CitrusSupport;
import com.consol.citrus.junit.jupiter.spring.XmlTestHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class CitrusSpringSupport
extends CitrusSupport {
    @Override
    public void beforeXmlTestExecution(ExtensionContext extensionContext) {
        CitrusExtensionHelper.getCitrus(extensionContext).run((TestAction)XmlTestHelper.getXmlTestCase(extensionContext), CitrusExtensionHelper.getTestContext(extensionContext));
    }

    @Override
    public void beforeEachXml(ExtensionContext extensionContext) {
        XmlTestHelper.getXmlTestCase(extensionContext);
    }

    @Override
    protected Citrus getCitrus() {
        if (citrus == null) {
            citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create());
        }
        return citrus;
    }

    public static Stream<DynamicTest> packageScan(String ... packagesToScan) {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        for (String packageScan : packagesToScan) {
            try {
                for (String fileNamePattern : CitrusSettings.getXmlTestFileNamePattern()) {
                    Resource[] fileResources;
                    for (Resource fileResource : fileResources = new PathMatchingResourcePatternResolver().getResources(packageScan.replace('.', File.separatorChar) + fileNamePattern)) {
                        String filePath = fileResource.getFile().getParentFile().getCanonicalPath();
                        if (packageScan.startsWith("file:")) {
                            filePath = "file:" + filePath;
                        }
                        filePath = filePath.substring(filePath.indexOf(packageScan.replace('.', File.separatorChar)));
                        String testName = fileResource.getFilename().substring(0, fileResource.getFilename().length() - ".xml".length());
                        XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, testName, filePath, citrus.getCitrusContext());
                        tests.add(DynamicTest.dynamicTest((String)testName, () -> citrus.run((TestAction)testLoader.load())));
                    }
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Unable to locate file resources for test package '" + packageScan + "'", (Throwable)e);
            }
        }
        return tests.stream();
    }

    public static Stream<DynamicTest> dynamicTests(String packageName, String ... testNames) {
        return Stream.of(testNames).map(testName -> {
            XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, testName, packageName, citrus.getCitrusContext());
            return DynamicTest.dynamicTest((String)testName, () -> citrus.run((TestAction)testLoader.load()));
        });
    }

    public static Stream<DynamicTest> dynamicTests(Class<?> testClass, String ... testNames) {
        return Stream.of(testNames).map(testName -> {
            XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, testName, testClass.getPackage().getName(), citrus.getCitrusContext());
            return DynamicTest.dynamicTest((String)testName, () -> citrus.run((TestAction)testLoader.load()));
        });
    }

    public static DynamicTest dynamicTest(String packageName, String testName) {
        XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, testName, packageName, citrus.getCitrusContext());
        return DynamicTest.dynamicTest((String)testName, () -> citrus.run((TestAction)testLoader.load()));
    }
}

