/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.jupiter.spring;

import com.consol.citrus.TestCase;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.XmlTestLoader;
import com.consol.citrus.junit.jupiter.CitrusExtensionHelper;
import com.consol.citrus.junit.jupiter.CitrusSupport;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class XmlTestHelper {
    private XmlTestHelper() {
    }

    public static TestLoader createTestLoader(ExtensionContext extensionContext) {
        Method method = extensionContext.getRequiredTestMethod();
        String testName = extensionContext.getRequiredTestClass().getSimpleName();
        String packageName = method.getDeclaringClass().getPackage().getName();
        if (method.getAnnotation(CitrusXmlTest.class) != null) {
            CitrusXmlTest citrusXmlTestAnnotation = method.getAnnotation(CitrusXmlTest.class);
            String[] packagesToScan = citrusXmlTestAnnotation.packageScan();
            if (StringUtils.hasText((String)citrusXmlTestAnnotation.packageName())) {
                packageName = citrusXmlTestAnnotation.packageName();
            }
            if (citrusXmlTestAnnotation.name().length > 0) {
                testName = citrusXmlTestAnnotation.name()[0];
            } else if (packagesToScan.length == 0) {
                testName = method.getName();
            }
        }
        return new XmlTestLoader(extensionContext.getRequiredTestClass(), testName, packageName, CitrusExtensionHelper.getCitrus(extensionContext).getCitrusContext());
    }

    public static TestCase getXmlTestCase(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCase)extensionContext.getRoot().getStore(CitrusSupport.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCase.class.getSimpleName()), key -> XmlTestHelper.createTestLoader(extensionContext).load(), TestCase.class);
    }
}

