/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.jupiter;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusInstanceManager;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.junit.jupiter.CitrusExtensionHelper;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class CitrusExtension
implements BeforeAllCallback,
InvocationInterceptor,
AfterTestExecutionCallback,
ParameterResolver,
TestInstancePostProcessor,
TestExecutionExceptionHandler,
AfterEachCallback,
AfterAllCallback {
    private static final String SUITE_NAME = "citrus-junit5-suite";
    private static boolean beforeSuite = true;
    private static boolean afterSuite = true;
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{CitrusExtension.class});

    public void beforeAll(ExtensionContext extensionContext) {
        if (CitrusExtensionHelper.requiresCitrus(extensionContext)) {
            CitrusExtensionHelper.setCitrus(CitrusInstanceManager.getOrDefault(), extensionContext);
        }
        if (beforeSuite) {
            beforeSuite = false;
            CitrusExtensionHelper.getCitrus(extensionContext).beforeSuite(SUITE_NAME, new String[0]);
        }
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (afterSuite) {
            afterSuite = false;
            CitrusExtensionHelper.getCitrus(extensionContext).afterSuite(SUITE_NAME, new String[0]);
        }
    }

    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        TestCase testCase = CitrusExtensionHelper.getTestCase(extensionContext);
        if (testCase.getTestResult() == null || testCase.getTestResult().isSuccess()) {
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)throwable));
        }
        throw throwable;
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        extensionContext.getExecutionException().ifPresent(e -> {
            TestCase testCase = CitrusExtensionHelper.getTestCase(extensionContext);
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
        });
        extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestContext.class.getSimpleName()));
        extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCase.class.getSimpleName()));
        Object testInstance = extensionContext.getRequiredTestInstance();
        if (testInstance instanceof TestListener) {
            ((TestListener)testInstance).after(CitrusExtensionHelper.getCitrus(extensionContext).getCitrusContext());
        }
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) {
        Object testInstance = extensionContext.getRequiredTestInstance();
        Citrus citrus = CitrusExtensionHelper.getCitrus(extensionContext);
        TestContext context = CitrusExtensionHelper.getTestContext(extensionContext);
        TestCaseRunner testRunner = CitrusExtensionHelper.getTestRunner(extensionContext);
        CitrusAnnotations.injectAll((Object)testInstance, (Citrus)citrus, (TestContext)context);
        CitrusAnnotations.injectTestRunner((Object)testInstance, (TestCaseRunner)testRunner);
        if (testInstance instanceof TestListener) {
            ((TestListener)testInstance).before(citrus.getCitrusContext());
        }
        TestLoader testLoader = CitrusExtensionHelper.getTestLoader(extensionContext);
        CitrusAnnotations.injectAll((Object)testLoader, (Citrus)citrus, (TestContext)context);
        CitrusAnnotations.injectTestRunner((Object)testLoader, (TestCaseRunner)testRunner);
        testLoader.doWithTestCase(t -> {
            try {
                invocation.proceed();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new CitrusRuntimeException("Test failed", e);
            }
        });
        testLoader.load();
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCaseRunner.class.getSimpleName()));
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        CitrusAnnotations.injectCitrusFramework((Object)testInstance, (Citrus)CitrusExtensionHelper.getCitrus(extensionContext));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().isAnnotationPresent(CitrusResource.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return CitrusExtensionHelper.resolveParameter(parameterContext, extensionContext);
    }

    public static interface TestListener {
        default public void before(CitrusContext context) {
        }

        default public void after(CitrusContext context) {
        }
    }
}

