/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.jupiter;

import com.consol.citrus.Citrus;
import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusTestSource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.DefaultTestLoader;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.TestSourceAware;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.junit.jupiter.CitrusExtension;
import com.consol.citrus.junit.jupiter.CitrusTestFactory;
import com.consol.citrus.util.FileUtils;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class CitrusExtensionHelper {
    private CitrusExtensionHelper() {
    }

    public static boolean isTestFactoryMethod(Method method) {
        return method.isAnnotationPresent(CitrusTestFactory.class);
    }

    public static boolean isTestSourceMethod(Method method) {
        return method.isAnnotationPresent(CitrusTestSource.class) || method.isAnnotationPresent(CitrusXmlTest.class);
    }

    public static TestCaseRunner createTestRunner(String testName, ExtensionContext extensionContext) {
        DefaultTestCaseRunner testCaseRunner = new DefaultTestCaseRunner((TestCase)new DefaultTestCase(), CitrusExtensionHelper.getTestContext(extensionContext));
        testCaseRunner.testClass(extensionContext.getRequiredTestClass());
        testCaseRunner.name(testName);
        testCaseRunner.packageName(extensionContext.getRequiredTestClass().getPackage().getName());
        return testCaseRunner;
    }

    public static TestCaseRunner getTestRunner(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCaseRunner)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCaseRunner.class.getSimpleName()), key -> {
            CitrusTest citrusTestAnnotation;
            Object testName = extensionContext.getRequiredTestClass().getSimpleName() + "." + extensionContext.getRequiredTestMethod().getName();
            if (extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class) != null && StringUtils.hasText((String)(citrusTestAnnotation = extensionContext.getRequiredTestMethod().getAnnotation(CitrusTest.class)).name())) {
                testName = citrusTestAnnotation.name();
            }
            return CitrusExtensionHelper.createTestRunner((String)testName, extensionContext);
        }, TestCaseRunner.class);
    }

    public static TestLoader getTestLoader(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestLoader)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestLoader.class.getSimpleName()), key -> CitrusExtensionHelper.createTestLoader(extensionContext), TestLoader.class);
    }

    public static TestCase getTestCase(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCase)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestCase.class.getSimpleName()), key -> {
            if (CitrusExtensionHelper.isTestSourceMethod(extensionContext.getRequiredTestMethod())) {
                return CitrusExtensionHelper.getTestLoader(extensionContext).getTestCase();
            }
            return CitrusExtensionHelper.getTestRunner(extensionContext).getTestCase();
        }, TestCase.class);
    }

    public static TestLoader createTestLoader(ExtensionContext extensionContext) {
        DefaultTestLoader testLoader;
        Method method = extensionContext.getRequiredTestMethod();
        if (CitrusExtensionHelper.isTestFactoryMethod(method)) {
            DefaultTestLoader testLoader2 = new DefaultTestLoader();
            CitrusExtensionHelper.configure((TestLoader)testLoader2, extensionContext, method, new String[0], null, new String[0], new String[0]);
            return testLoader2;
        }
        if (method.getAnnotation(CitrusXmlTest.class) != null) {
            CitrusXmlTest citrusTestAnnotation = method.getAnnotation(CitrusXmlTest.class);
            TestLoader testLoader3 = (TestLoader)TestLoader.lookup((String)"spring").orElseThrow(() -> new CitrusRuntimeException(String.format("Missing test loader for type '%s'", "spring")));
            CitrusExtensionHelper.configure(testLoader3, extensionContext, method, citrusTestAnnotation.name(), citrusTestAnnotation.packageName(), citrusTestAnnotation.packageScan(), citrusTestAnnotation.sources());
            return testLoader3;
        }
        if (CitrusExtensionHelper.isTestSourceMethod(method)) {
            CitrusTestSource citrusTestAnnotation = method.getAnnotation(CitrusTestSource.class);
            testLoader = (TestLoader)TestLoader.lookup((String)citrusTestAnnotation.type()).orElseThrow(() -> new CitrusRuntimeException(String.format("Missing test loader for type '%s'", citrusTestAnnotation.type())));
            CitrusExtensionHelper.configure((TestLoader)testLoader, extensionContext, method, citrusTestAnnotation.name(), citrusTestAnnotation.packageName(), citrusTestAnnotation.packageScan(), citrusTestAnnotation.sources());
        } else {
            testLoader = new DefaultTestLoader();
            CitrusExtensionHelper.configure((TestLoader)testLoader, extensionContext, method, new String[0], null, new String[0], new String[0]);
        }
        return testLoader;
    }

    public static TestContext getTestContext(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestContext)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).getOrComputeIfAbsent((Object)(CitrusExtensionHelper.getBaseKey(extensionContext) + TestContext.class.getSimpleName()), key -> CitrusExtensionHelper.getCitrus(extensionContext).getCitrusContext().createTestContext(), TestContext.class);
    }

    public static String getBaseKey(ExtensionContext extensionContext) {
        return extensionContext.getRequiredTestClass().getName() + "." + extensionContext.getRequiredTestMethod().getName() + "#";
    }

    public static Citrus getCitrus(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        Citrus citrus = (Citrus)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).get((Object)Citrus.class.getName(), Citrus.class);
        if (citrus == null) {
            throw new CitrusRuntimeException("Missing Citrus instance in JUnit5 extension context");
        }
        return citrus;
    }

    public static void setCitrus(Citrus citrus, ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).put((Object)Citrus.class.getName(), (Object)citrus);
    }

    public static Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        TestCaseRunner runner = CitrusExtensionHelper.getTestRunner(extensionContext);
        if (TestCaseRunner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return runner;
        }
        if (GherkinTestActionRunner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return runner;
        }
        if (TestActionRunner.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return runner;
        }
        if (TestContext.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return CitrusExtensionHelper.getTestContext(extensionContext);
        }
        throw new CitrusRuntimeException(String.format("Failed to resolve parameter %s", parameterContext.getParameter()));
    }

    public static boolean requiresCitrus(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        Citrus citrus = (Citrus)extensionContext.getRoot().getStore(CitrusExtension.NAMESPACE).get((Object)Citrus.class.getName(), Citrus.class);
        return citrus == null;
    }

    private static void configure(TestLoader testLoader, ExtensionContext extensionContext, Method method, String[] methodNames, String methodPackageName, String[] packagesToScan, String[] sources) {
        String testName = extensionContext.getRequiredTestClass().getSimpleName();
        String packageName = method.getDeclaringClass().getPackage().getName();
        String source = null;
        if (StringUtils.hasText((String)methodPackageName)) {
            packageName = methodPackageName;
        }
        if (methodNames.length > 0) {
            testName = methodNames[0];
        } else if (packagesToScan.length == 0 && sources.length == 0) {
            testName = method.getName();
        }
        if (sources.length > 0) {
            source = sources[0];
            Resource file = FileUtils.getFileResource((String)source);
            testName = FileUtils.getBaseName((String)file.getFilename());
            packageName = source;
            if (packageName.startsWith("classpath:")) {
                packageName = source.substring("classpath:".length());
            }
            if (StringUtils.hasLength((String)packageName) && packageName.contains("/")) {
                packageName = packageName.substring(0, packageName.lastIndexOf("/"));
            }
            packageName = packageName.replace("/", ".");
        }
        testLoader.setTestClass(extensionContext.getRequiredTestClass());
        testLoader.setTestName(testName);
        testLoader.setPackageName(packageName);
        CitrusAnnotations.injectAll((Object)testLoader, (Citrus)CitrusExtensionHelper.getCitrus(extensionContext));
        if (testLoader instanceof TestSourceAware) {
            ((TestSourceAware)testLoader).setSource(source);
        }
    }
}

