/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.jupiter.spring;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContextProvider;
import com.consol.citrus.CitrusSpringContextProvider;
import com.consol.citrus.junit.jupiter.CitrusExtension;
import com.consol.citrus.junit.jupiter.CitrusExtensionHelper;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.junit.jupiter.SpringExtension;

public class CitrusSpringExtension
implements BeforeAllCallback,
BeforeTestExecutionCallback,
InvocationInterceptor,
AfterTestExecutionCallback,
ParameterResolver,
TestInstancePostProcessor,
TestExecutionExceptionHandler,
AfterEachCallback,
AfterAllCallback {
    private Citrus citrus;
    private ApplicationContext applicationContext;
    private final CitrusExtension delegate = new CitrusExtension();

    public void beforeAll(ExtensionContext extensionContext) {
        CitrusExtensionHelper.setCitrus(this.getCitrus(extensionContext), extensionContext);
        this.delegate.beforeAll(extensionContext);
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        this.delegate.afterAll(extensionContext);
    }

    public void handleTestExecutionException(ExtensionContext extensionContext, Throwable throwable) throws Throwable {
        this.delegate.handleTestExecutionException(extensionContext, throwable);
    }

    public void afterTestExecution(ExtensionContext extensionContext) {
        this.delegate.afterTestExecution(extensionContext);
    }

    public void beforeTestExecution(ExtensionContext extensionContext) {
        CitrusExtensionHelper.setCitrus(this.getCitrus(extensionContext), extensionContext);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        this.delegate.interceptTestMethod(invocation, invocationContext, extensionContext);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        this.delegate.afterEach(extensionContext);
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) {
        this.delegate.postProcessTestInstance(testInstance, extensionContext);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.delegate.supportsParameter(parameterContext, extensionContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.delegate.resolveParameter(parameterContext, extensionContext);
    }

    protected Citrus getCitrus(ExtensionContext extensionContext) {
        ApplicationContext ctx = SpringExtension.getApplicationContext((ExtensionContext)extensionContext);
        if (this.applicationContext == null) {
            this.applicationContext = ctx;
            this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(ctx));
        } else if (!this.applicationContext.equals(ctx)) {
            this.applicationContext = ctx;
            this.citrus = Citrus.newInstance((CitrusContextProvider)new CitrusSpringContextProvider(ctx));
        }
        return this.citrus;
    }
}

