/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.kafka.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.kafka.config.annotation.KafkaEndpointConfig;
import com.consol.citrus.kafka.endpoint.KafkaEndpoint;
import com.consol.citrus.kafka.endpoint.KafkaEndpointBuilder;
import com.consol.citrus.kafka.message.KafkaMessageConverter;
import com.consol.citrus.kafka.message.KafkaMessageHeaderMapper;
import java.util.Map;
import org.springframework.util.StringUtils;

public class KafkaEndpointConfigParser
extends AbstractAnnotationConfigParser<KafkaEndpointConfig, KafkaEndpoint> {
    public KafkaEndpointConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public KafkaEndpoint parse(KafkaEndpointConfig annotation) {
        KafkaEndpointBuilder builder = new KafkaEndpointBuilder();
        String server = annotation.server();
        if (!StringUtils.hasText((String)server)) {
            throw new CitrusRuntimeException("Required server is missing for kafka configuration");
        }
        builder.server(server);
        builder.topic(annotation.topic());
        builder.partition(annotation.partition());
        builder.autoCommit(annotation.autoCommit());
        builder.autoCommitInterval(annotation.autoCommitInterval());
        builder.offsetReset(annotation.offsetReset());
        if (StringUtils.hasText((String)annotation.clientId())) {
            builder.clientId(annotation.clientId());
        }
        builder.consumerGroup(annotation.consumerGroup());
        if (StringUtils.hasText((String)annotation.producerProperties())) {
            builder.producerProperties((Map)this.getReferenceResolver().resolve(annotation.producerProperties(), Map.class));
        }
        if (StringUtils.hasText((String)annotation.consumerProperties())) {
            builder.consumerProperties((Map)this.getReferenceResolver().resolve(annotation.consumerProperties(), Map.class));
        }
        builder.keySerializer(annotation.keySerializer());
        builder.keyDeserializer(annotation.keyDeserializer());
        builder.valueSerializer(annotation.valueSerializer());
        builder.valueDeserializer(annotation.valueDeserializer());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((KafkaMessageConverter)this.getReferenceResolver().resolve(annotation.messageConverter(), KafkaMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.headerMapper())) {
            builder.headerMapper((KafkaMessageHeaderMapper)this.getReferenceResolver().resolve(annotation.headerMapper(), KafkaMessageHeaderMapper.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (KafkaEndpoint)builder.initialize().build();
    }
}

