/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.kafka.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.kafka.endpoint.KafkaEndpointConfiguration;
import com.consol.citrus.kafka.message.KafkaMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageConverter;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.springframework.core.io.Resource;

public class KafkaMessageConverter
implements MessageConverter<ConsumerRecord<Object, Object>, ProducerRecord<Object, Object>, KafkaEndpointConfiguration> {
    public ProducerRecord<Object, Object> convertOutbound(Message internalMessage, KafkaEndpointConfiguration endpointConfiguration, TestContext context) {
        Object payload;
        if (internalMessage.getPayload() instanceof String) {
            payload = context.replaceDynamicContentInString((String)internalMessage.getPayload(String.class));
        } else if (internalMessage.getPayload() instanceof Resource) {
            try {
                payload = context.replaceDynamicContentInString(FileUtils.readToString((Resource)((Resource)internalMessage.getPayload(Resource.class))));
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read payload resource");
            }
        } else {
            payload = internalMessage.getPayload();
        }
        KafkaMessage kafkaMessage = internalMessage instanceof KafkaMessage ? (KafkaMessage)internalMessage : new KafkaMessage(internalMessage.getPayload(), internalMessage.getHeaders());
        return new ProducerRecord(Optional.ofNullable(kafkaMessage.getTopic()).map(arg_0 -> ((TestContext)context).replaceDynamicContentInString(arg_0)).orElse(context.replaceDynamicContentInString(endpointConfiguration.getTopic())), Optional.ofNullable(kafkaMessage.getPartition()).orElse(endpointConfiguration.getPartition()), kafkaMessage.getMessageKey(), payload, (Iterable)endpointConfiguration.getHeaderMapper().toHeaders(kafkaMessage.getHeaders()));
    }

    public void convertOutbound(ProducerRecord<Object, Object> externalMessage, Message internalMessage, KafkaEndpointConfiguration endpointConfiguration, TestContext context) {
    }

    public Message convertInbound(ConsumerRecord<Object, Object> consumerRecord, KafkaEndpointConfiguration endpointConfiguration, TestContext context) {
        if (consumerRecord == null) {
            return null;
        }
        return new KafkaMessage(consumerRecord.value(), endpointConfiguration.getHeaderMapper().fromHeaders(consumerRecord.headers())).topic(consumerRecord.topic()).timestamp(consumerRecord.timestamp()).partition(consumerRecord.partition()).offset(consumerRecord.offset()).messageKey(consumerRecord.key());
    }
}

