/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.kafka.message;

import com.consol.citrus.util.TypeConversionUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;

public class KafkaMessageHeaderMapper {
    public Map<String, Object> fromHeaders(Headers kafkaHeaders) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        kafkaHeaders.forEach(header -> headers.put(header.key(), new String(header.value())));
        return headers;
    }

    public Headers toHeaders(Map<String, Object> headers) {
        RecordHeaders kafkaHeaders = new RecordHeaders();
        for (Map.Entry<String, Object> headerEntry : headers.entrySet()) {
            if (headerEntry.getKey().startsWith("citrus_kafka_") || headerEntry.getKey().equals("citrus_message_id") || headerEntry.getKey().equals("citrus_message_timestamp")) continue;
            kafkaHeaders.add(headerEntry.getKey(), (byte[])TypeConversionUtils.convertIfNecessary((Object)headerEntry.getValue(), byte[].class));
        }
        return kafkaHeaders;
    }
}

